import { Injectable } from '@angular/core';
import { Http, Response } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import { Subject } from 'rxjs/Subject';
import 'rxjs/add/operator/map';

import { environment } from '../../../../environments/environment';

@Injectable()
export class EditStationService {
  constructor(private http: Http) {}
  currentStation: {};
  addZipCodeSuccessMessage = '';
  addContactInfoSuccessMessage = '';
  currentStationId: string;
  notify = new Subject<{ ['message']: string; ['boolean']: boolean }>();

  setCurrentStation(id) {
    this.currentStationId = id;
  }

  getCurrentStation() {
    // return new Observable(observer => observer.next(this.currentStation));
    console.log('getCurrentStation service method ', this.currentStationId);
    return this.http
      .get(
        `${environment.nodeserver}/editStation/getStationInfo/${this
          .currentStationId}`
      )
      .map((response: Response) => response.json());
  }

  setAddZipCodeSuccessMessage(addZipCodeSuccessMessage) {
    if (addZipCodeSuccessMessage) {
      this.addZipCodeSuccessMessage = addZipCodeSuccessMessage;
    } else {
      this.addZipCodeSuccessMessage = '';
    }
  }

  setAddContactInfoSuccessMessage(addContactInfoSuccessMessage) {
    if (addContactInfoSuccessMessage) {
      this.addContactInfoSuccessMessage = addContactInfoSuccessMessage;
    } else {
      this.addContactInfoSuccessMessage = '';
    }
  }

  getAddZipCodeSuccessMessage(): Observable<{}> {
    return new Observable(observer =>
      observer.next(this.addZipCodeSuccessMessage)
    );
  }

  getAddContactInfoSuccessMessage(): Observable<{}> {
    return new Observable(observer =>
      observer.next(this.addContactInfoSuccessMessage)
    );
  }

  getVisN() {
    return this.http
      .get(`${environment.nodeserver}/editStation/visns`)
      .map((data: Response) => data.json());
  }

  getTypes() {
    return this.http
      .get(`${environment.nodeserver}/editStation/types`)
      .map((data: Response) => data.json());
  }

  updateCurrentStation(updatedStation) {
    return this.http
      .put(
        `${environment.nodeserver}/editStation/updateStation`,
        updatedStation
      )
      .map((response: Response) => response.json());
  }

  deleteStation(station) {
    return this.http
      .delete(`${environment.nodeserver}/editStation/deleteStation/${station}`)
      .map((response: Response) => response.json());
  }

  // onNotify method is used to pass a particular message and a boolean to display to the user once page has been redirected.
  onNotify(obj: { ['message']: string; ['boolean']: boolean }) {
    // the station was successfully deleted.
    console.log('onNotify was executed');
    setTimeout(() => {
      this.notify.next(obj);
    }, 2000);

    //   return this.notify.asObservable();
  }
}
