import { Component, OnInit, EventEmitter, Output } from '@angular/core';
import {
  FormControl,
  FormGroup,
  FormBuilder,
  Validators
} from '@angular/forms';
import { Router } from '@angular/router';

import { EditStationService } from './station-edit-maintenance.service';
import { StationMaintenanceAddZipCodeService } from '../addZipCode/station-maintenance-add-zip-code.service';
import { StationMaintenanceAddContactInfoService } from '../add-contact-info/station-maintenance-add-contact-info.service';
import { TableComponent } from '../../../shared/table/table.component';
import { ColumnMetadata } from '../../../shared/table/cols.model';
import { TableOptions } from '../../../shared/table/table-options.model';
import { ContactInfoModel } from './contact-info.model';
import { ZipCodeModel } from './zipcode.model';

@Component({
  selector: 'app-station-maintenance',
  templateUrl: './station-edit-maintenance.component.html',
  styleUrls: ['./station-edit-maintenance.component.scss']
})
export class StationMaintenanceEditComponent implements OnInit {
  @Output() notify = new EventEmitter<boolean>();
  form: FormGroup;
  stationError = false;
  errorMessage = '';
  modalClosed = true;

  // change below
  currentStation;
  // currentStation: StationModel;
  //
  visnList = [];
  typeList = [];
  // fix this\
  userInfo;
  appUserName;
  visnValue = '';
  typeValue = '';
  shortNameValue = '';
  ageDefinitionValue: number;
  nameValue = '';
  parentStationValue = '';
  stationNumber = '';
  reroutingAllowed;
  // end
  stationUpdateResponse;
  fetchingData = false;
  contactInfoData: ContactInfoModel[] = [new ContactInfoModel()];
  zipCodeData: ZipCodeModel[] = [new ZipCodeModel()];
  addZipCodeSuccessMessage = '';
  addContactInfoSuccessMessage = '';
  tableOptions = new TableOptions()
    .setNoPagination(true)
    .setNoNumPerPage(true)
    .setNoShowNumResults(true);
  // {vaFacilityCd: "009", zip_code: "13131", active: true, created_by: "VHAISMBAIAHBBB", date_created: "10/24/2017 09:44:37 AM"}
  zipCodeColums: ColumnMetadata[] = [
    new ColumnMetadata('zip_code', 'ZIP Code'),
    new ColumnMetadata('active', 'Active Flag'),
    new ColumnMetadata('fips_state_code', 'FIPS State Code').setAlign('right'),
    new ColumnMetadata('fips_county_code', 'FIPS County Code').setAlign(
      'right'
    ),
    new ColumnMetadata('urban_indicator', 'Urban Indicator').setAlign('right'),
    new ColumnMetadata('created_by', 'Created By'),
    new ColumnMetadata('date_created', 'Date Created').setAlign('right'),
    new ColumnMetadata('modifyButton', 'Modify').setButton(true).setSort(false)
  ];

  contactInfoColums: ColumnMetadata[] = [
    new ColumnMetadata('contactName', 'Contact Name'),
    new ColumnMetadata('contactType', 'Contact Type'),
    new ColumnMetadata('address1', 'Address 1'),
    new ColumnMetadata('address2', 'Address 2'),
    new ColumnMetadata('city', 'City'),
    new ColumnMetadata('zip', 'ZIP Code').setAlign('right'),
    new ColumnMetadata('email', 'Email'),
    new ColumnMetadata('fax', 'Fax').setAlign('right'),
    new ColumnMetadata('phone', 'Phone').setAlign('right'),
    new ColumnMetadata('createdBy', 'Created By'),
    new ColumnMetadata('dateCreated', 'Date Created')
      .setAlign('right')
      .setDate(true),
    new ColumnMetadata('modifyButton', 'Modify')
      .setButton(true)
      .setSort(false)
      .setAlign('center')
  ];

  constructor(
    private fb: FormBuilder,
    private editStationService: EditStationService,
    private stationMaintenenceAddZipCodeService: StationMaintenanceAddZipCodeService,
    private stationMaintenanceAddContactInfoService: StationMaintenanceAddContactInfoService,
    private router: Router
  ) {
    this.formInit();
  }

  ngOnInit() {
    console.log('this is init');
    this.editStationService.getCurrentStation().subscribe(data => {
      console.log('this is what we want!', data);
      this.currentStation = data;
      if (data.zipcodes.length > 0) {
        this.zipCodeData = data.zipcodes;
      } else {
        this.zipCodeData = [];
      }

      if (data.contactInfoRequest.length > 0) {
        this.contactInfoData = data.contactInfoRequest;
      } else {
        this.contactInfoData = [];
      }
      this.userInfo = JSON.parse(sessionStorage.getItem('userInfo'));
      this.appUserName = this.userInfo.userName;
      this.visnValue = this.currentStation.visnNumber;
      this.typeValue = this.currentStation.stationType;
      this.parentStationValue = this.currentStation.parentStation;
      this.stationNumber = this.currentStation.station;
      this.shortNameValue = this.currentStation.shortName;
      this.nameValue = this.currentStation.stationName;
      this.ageDefinitionValue = this.currentStation.agedDef;
      this.reroutingAllowed = this.currentStation.allowReroute;
    });

    this.editStationService.getVisN().subscribe(visn => {
      this.visnList = visn;
    });

    this.editStationService.getTypes().subscribe(types => {
      this.typeList = types;
    });

    this.editStationService.getAddZipCodeSuccessMessage().subscribe(message => {
      this.addZipCodeSuccessMessage = String(message);
      this.editStationService.setAddZipCodeSuccessMessage('');
    });

    this.editStationService
      .getAddContactInfoSuccessMessage()
      .subscribe(message => {
        this.addContactInfoSuccessMessage = String(message);
        this.editStationService.setAddContactInfoSuccessMessage('');
      });
  }

  visnSelected(visn) {
    this.visnValue = visn;
  }

  typeSelected(type) {
    this.typeValue = type;
  }

  onSubmit() {
    const updatedStation = {
      appUserName: this.appUserName,
      vaFacilityCd: this.stationNumber,
      visnIdCd: this.visnValue,
      vaTypeCd: this.typeValue,
      parentVaFacilityCd: this.parentStationValue,
      vaFacilityName: this.nameValue,
      shortName: this.shortNameValue,
      agedDefinition: this.ageDefinitionValue,
      reroutingAllowed: this.reroutingAllowed
    };
    this.editStationService
      .updateCurrentStation(updatedStation)
      .subscribe(data => {
        if (data.result) {
          this.stationUpdateResponse = data;
          this.editStationService.onNotify({
            message: `Station ${this.stationNumber} was successfully edited.`,
            boolean: true
          });
          this.router.navigate([`viewStation/${updatedStation.vaFacilityCd}`]);
        } else {
          this.stationError = true;
          this.errorMessage = data.errorMessage;
        }
      });
  }
  onDeleteAlert() {
    this.modalClosed = false;
  }
  onDelete() {
    this.editStationService
      .deleteStation(this.stationNumber)
      .subscribe(response => {
        if (response.result) {
          this.editStationService.onNotify({
            message: `Station ${this.stationNumber} was successfully deleted.`,
            boolean: true
          });
          this.router.navigate(['searchStation']);
        } else {
          this.stationError = true;
          this.errorMessage = response.errorMessage;
        }
      });
  }

  // Franklin Perez (10/25/2017): The below is needed so that when the user clicks
  //   on the "Add ZIP Code" button, the user will get forwarded to the
  //   "Station Maintenance | Add ZIP Code" Page.
  addZipCode() {
    this.stationMaintenenceAddZipCodeService.setStation(this.currentStation);
    this.router.navigate(['addZipCode']);
  }

  // Franklin Perez (10/25/2017): The below is needed so that when the user clicks
  //   on the "Add Contact Info" button, the user will get forwarded to the
  //   "Station Maintenance | Add Contact Info" Page.
  addContactInfo() {
    this.stationMaintenanceAddContactInfoService.setStation(
      this.currentStation
    );
    this.router.navigate(['addContactInfo']);
  }

  formInit() {
    this.form = this.fb.group({
      visnDropDown: [this.visnValue, Validators.required],
      shortName: [this.shortNameValue, Validators.maxLength(80)],
      ageDefinition: [
        this.ageDefinitionValue,
        Validators.compose([
          Validators.maxLength(10),
          Validators.pattern('[0-9]*')
        ])
      ],
      typeDropDown: [this.typeValue, Validators.required],
      name: [this.nameValue, Validators.maxLength(100)],
      parentStation: [this.parentStationValue, Validators.maxLength(36)],
      canBeRouted: [this.reroutingAllowed]
    });
    this.form.reset();
  }

  formSetValue() {
    this.form.setValue({
      visnDropDown: this.visnValue,
      shortName: this.shortNameValue,
      ageDefinition: this.ageDefinitionValue,
      typeDropDown: this.typeValue,
      name: this.nameValue,
      parentStation: this.parentStationValue,
      canBeRouted: this.reroutingAllowed
    });
  }
  onModalClose(bool) {
    this.modalClosed = bool;
  }

  onZipCodeEdit() {
    // will need to pass info through service
    this.router.navigate(['editZipCode']);
  }
  onContactInfoEdit() {
    // will need to pass info through service
    this.router.navigate(['editContactInfo']);
  }
}
