import { Observable } from 'rxjs/Observable';
import { StationMaintenanceEditComponent } from './station-edit-maintenance.component';
import { StationMaintenanceAddZipCodeService } from '../addZipCode/station-maintenance-add-zip-code.service';
import { EditStationService } from './station-edit-maintenance.service';
import { FormBuilder } from '@angular/forms';
import 'rxjs/add/observable/from';

describe('StationEditComponent', () => {
  let editService: EditStationService;
  let zipCodeService: StationMaintenanceAddZipCodeService;
  let component: StationMaintenanceEditComponent;
  beforeEach(() => {
    editService = new EditStationService(null);
    zipCodeService = new StationMaintenanceAddZipCodeService(null);
    // component = new StationMaintenanceEditComponent(editService, zipCodeService, null;
    component = new StationMaintenanceEditComponent(
      new FormBuilder(),
      editService,
      zipCodeService,
      null,
      null
    );
  });
  it('should get currentStation, visn, types and zipcodes from service', () => {
    const station = {
      appUserName: 'VHAISMBAIAHBBB',
      vaFacilityCd: '4567',
      visnIdCd: '2',
      vaTypeCd: 'RO',
      parentVaFacilityCd: '',
      vaFacilityName: '',
      shortName: '',
      agedDefinition: '',
      reroutingAllowed: false
    };
    const visn = [1, 2, 3];
    const types = [1, 2, 3];
    const zipCodeSuccessMessage = 'zipCodeSuccessMessage';
    spyOn(editService, 'getCurrentStation').and.callFake(() => {
      return new Observable(observer => observer.next(station));
    });
    spyOn(editService, 'getVisN').and.callFake(() => {
      return Observable.from([visn]);
    });
    spyOn(editService, 'getTypes').and.callFake(() => {
      return Observable.from([types]);
    });
    spyOn(editService, 'getAddZipCodeSuccessMessage').and.callFake(() => {
      return new Observable(observer => observer.next(zipCodeSuccessMessage));
    });
    component.ngOnInit();
    expect(component.currentStation).toBe(station);
    expect(component.visnList).toBe(visn);
    expect(component.typeList).toBe(types);
    expect(component.addZipCodeSuccessMessage).toBe(zipCodeSuccessMessage);
  });
  it('should set visn to what the user selected', () => {
    const selectedVisn = 'selected visn';
    component.visnSelected(selectedVisn);
    expect(component.visnValue).toBe(selectedVisn);
  });
  it('should set types to what the user selected', () => {
    const selectedType = 'selected type';
    component.typeSelected(selectedType);
    expect(component.typeValue).toBe(selectedType);
  });
  it('should submit station changes to the service passing all required information', () => {
    const updateResponseMessage = 'successfull';
    spyOn(editService, 'updateCurrentStation').and.callFake(() => {
      return new Observable(observer => observer.next(updateResponseMessage));
    });
    component.onSubmit();
    expect(component.stationUpdateResponse).toBe(updateResponseMessage);
  });
});
// this commented section is not using 'Unit testing';

// import { async, ComponentFixture, TestBed } from '@angular/core/testing';
// import { MenuComponent } from '../../../shared/menu/menu.component';
// import { RouterTestingModule } from '@angular/router/testing';
// import { HttpModule } from '@angular/http';
// import { FormsModule } from '@angular/forms';
// import { DebugElement, SimpleChanges } from '@angular/core';
// import { By } from '@angular/platform-browser';
// import { EditStationService } from './station-edit-maintenance.service';
// import { StationMaintenanceEditComponent } from './station-edit-maintenance.component';

// describe('StationMaintenanceEditComponent', () => {
// 	let component: StationMaintenanceEditComponent;
// 	let fixture: ComponentFixture<StationMaintenanceEditComponent>;

// 	beforeEach(async(() => {
// 		TestBed.configureTestingModule({
// 			imports: [FormsModule, HttpModule, RouterTestingModule],
// 			declarations: [StationMaintenanceEditComponent, MenuComponent],
// 			providers: [EditStationService]
// 		})
// 			.compileComponents();
// 	}));

// 	beforeEach(() => {
// 		fixture = TestBed.createComponent(StationMaintenanceEditComponent);
// 		component = fixture.componentInstance;
// 		fixture.detectChanges();

// 		component.currentStation = {
// 			'visnIdCd': '5',
// 			'vaTypeCd': 'OM',
// 			'vaFacilityCd': 'blah'
// 		};
// 		component.visnValue = this.currentStation.visnIdCd;
// 		component.typeValue = this.currentStation.vaTypeCd;
// 		component.stationNumber = this.currentStation.vaFacilityCd;

// 		component.visnList = [
// 			{ 'visnIdCd': '123' },
// 			{ 'visnIdCd': '456' }
// 		];

// 		component.typeList = [
// 			{ 'vaTypeCd': 'asdf' },
// 			{ 'vaTypeCd': 'fdsa' }
// 		]

// 	});

// 	it('should be created', () => {
// 		expect(component).toBeTruthy();
// 	});

// 	it('should have a 'VISN' ', () => {
// 		const debugElement: DebugElement = fixture.debugElement.query(By.css('#visn'));
// 		const htmlElement: HTMLElement = debugElement.nativeElement;

// 		expect(htmlElement.hidden).toBe(false);
// 		expect(htmlElement).toBeTruthy();
// 	});

// 	it('should have a 'TYPE' ', () => {
// 		const debugElement: DebugElement = fixture.debugElement.query(By.css('#type'));
// 		const htmlElement: HTMLElement = debugElement.nativeElement;

// 		expect(htmlElement.hidden).toBe(false);
// 		expect(htmlElement).toBeTruthy();
// 	});
// });
