import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';

import { RequestOptions, URLSearchParams, Headers, Response, Http } from '@angular/http';
import { environment } from '../../../../environments/environment';

@Injectable()
export class StationMaintenanceAddZipCodeService {
	station = { };

	constructor(private http: Http) { }

	setStation(station) {
		this.station = station;
	}

	getStation(): Observable<any> {
		return new Observable(observer => observer.next(this.station));
	}

	zipCodeCheck(zipCode) {
		// console.log('StationMaintenanceAddZipCodeService.zipCodeCheck: zipCode = ', zipCode)
		return this.http.get(`${environment.nodeserver}/tools/addZipCode/zipCodeCheck/${zipCode}`)
			.map((response: Response) => response.json());
	}

	zipCodeSave(body) {
		return this.http.post(`${environment.nodeserver}/tools/addZipCode/zipCodeSave`, body)
			.map((response: Response) => response.json());
	}
}
