import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

import { ColumnMetadata } from '../../../shared/table/cols.model';

import { StationMaintenanceAddZipCodeService } from './station-maintenance-add-zip-code.service';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';

@Component({
  selector: 'app-station-maintenance-add-zip-code',
  templateUrl: './station-maintenance-add-zip-code.component.html',
  styleUrls: ['./station-maintenance-add-zip-code.component.scss']
})
export class StationMaintenanceAddZipCodeComponent implements OnInit {
  receivedDataStation = null;
  aStation = null;

  selectedActive = 'Yes';
  selectedZipCode = '';
  selectedFipsCountyCode = '';
  selectedUrbanIndicator = '';
  selectedFipsStateCode = '';

  addZipCodeErrorMessage = '';

  existentZipCode = false; // boolean that will toggle to indicate if Zip Code already exists for Station

  f: NgForm;
  @ViewChild('f') currentForm: NgForm;

  constructor(
    private stationMaintenanceAddZipCodeService: StationMaintenanceAddZipCodeService,
    private editStationService: EditStationService,
    private router: Router
  ) {}

  ngOnInit() {
    // console.log('Inside of StationMaintenanceAddZipCodeComponent.ngOnInit!');

    this.selectedActive = 'Yes';

    this.stationMaintenanceAddZipCodeService.getStation().subscribe(data => {
      // console.log('  data = ' + JSON.stringify(data));
      this.receivedDataStation = data;

      this.aStation = {
        stationId: '',
        shortName: '',
        name: '',
        type: '',
        visn: '',
        allowReroute: 'false',
        agedDefinition: '',
        parentStation: '',
        createdBy: '',
        dateCreated: ''
      };

      if (data.station) {
        this.aStation.stationId = data.station;
      }

      if (data.shortName) {
        this.aStation.shortName = data.shortName;
      }

      if (data.stationName) {
        this.aStation.name = data.stationName;
      }

      if (data.stationType) {
        this.aStation.type = data.stationType;
      }

      if (data.visnNumber) {
        this.aStation.visn = data.visnNumber;
      }

      if (data.allowReroute) {
        this.aStation.allowReroute = String(data.allowReroute);
      }

      if (data.agedDef) {
        this.aStation.agedDefinition = String(data.agedDef);
      }

      if (data.parentStation) {
        this.aStation.parentStation = data.parentStation;
      }

      if (data.createdBy) {
        this.aStation.createdBy = String(data.createdBy);
      }

      if (data.dateCreated) {
        this.aStation.dateCreated = data.dateCreated.split(' ')[0];
      }
    });

    // Debug Code Below.
    /*
      this.station = [
        {
          'stationId': '999',
          'shortName': 'GENHOSP',
          'name': 'General Hospital',
          'type': 'HOSP',
          'visn': '9',
          'allowReroute': 'true',
          'agedDefinition': '',
          'parentStation': '',
          'createdBy': 'DNS   MBAIAH',
          'dateCreated': '01/01/2017 12:59 PM'
        }
      ];
    */
  }

  zipCodeKeyPress(event: any) {
    // console.log('Inside of StationMaintenanceAddZipCodeComponent.zipCodeKeyPress !');

    // const pattern = /[0-9]/;
    const inputChar = String.fromCharCode(event.charCode);
    // console.log('  inputChar = ' + inputChar);

    /*
      if (!pattern.test(inputChar)) {
        // invalid character, prevent input
        event.preventDefault();
      }
    */

    const latestValue = this.selectedZipCode + inputChar;
    if (latestValue.length > 5) {
      // if (latestValue.length > 10) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }

    if (latestValue.length < 5) {
      // if (latestValue.length < 1) {
      this.existentZipCode = false;
    }

    // console.log('  existentZipCode = ' + this.existentZipCode);
  }

  zipCodeChange(newZipCodeValue) {
    // console.log('Inside of StationMaintenanceAddZipCodeComponent.zipCodeChange !');
    // console.log('   newZipCodeValue = ' + newZipCodeValue);
    // console.log('   this.selectedZipCode = ' + this.selectedZipCode);

    if (newZipCodeValue.length < 6) {
      // if (newZipCodeValue.length < 11) {
      this.selectedZipCode = newZipCodeValue;
    }

    if (this.selectedZipCode.length < 5) {
      // if (this.selectedZipCode.length < 1) {
      this.existentZipCode = false;
    }

    // if (this.selectedZipCode.length === 5) {
    if (this.selectedZipCode.length > 0) {
      this.onZipCodeBlurCheck();
    }

    // console.log('   this.selectedZipCode = ' + this.selectedZipCode);
  }

  onZipCodeBlurCheck() {
    // console.log(
    //   'StationMaintenanceAddZipCodeComponent.onZipCodeBlurCheck: selectedZipCode = ' +
    //     this.selectedZipCode
    // );
    // if (this.selectedZipCode.length === 5) {
    if (this.selectedZipCode.length > 0) {
      // console.log('   5 digits!');

      this.stationMaintenanceAddZipCodeService
        .zipCodeCheck(this.selectedZipCode)
        .subscribe(data => {
          // console.log('  response data ' + JSON.stringify(data));
          // console.log('  response data.result = ' + data.result);
          // console.log('  response data.error_code = ' + data.error_code);
          // console.log(
          //   '  response data.error_description = ' + data.error_description
          // );

          if (data.result !== null && data.result !== undefined) {
            this.existentZipCode = data.result;
          } else {
            this.existentZipCode = true;
          }

          // console.log(
          //   '  from response data: existentZipCode = ' + this.existentZipCode
          // );
        });
    } else {
      this.existentZipCode = false;
    }

    // console.log('  existentZipCode = ' + this.existentZipCode);
  }

  fipsCountyCodeKeyPress(event: any) {
    const pattern = /[A-Za-z0-9]/;
    const inputChar = String.fromCharCode(event.charCode);

    if (!pattern.test(inputChar)) {
      // invalid character, prevent input
      event.preventDefault();
    }

    const latestValue = this.selectedFipsCountyCode + inputChar;
    if (latestValue.length > 3) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  fipsStateCodeKeyPress(event: any) {
    const pattern = /[A-Za-z0-9]/;
    const inputChar = String.fromCharCode(event.charCode);

    if (!pattern.test(inputChar)) {
      // invalid character, prevent input
      event.preventDefault();
    }

    const latestValue = this.selectedFipsStateCode + inputChar;
    if (latestValue.length > 2) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  urbanIndicatorCodeKeyPress(event: any) {
    const pattern = /[A-Za-z0-9]/;
    const inputChar = String.fromCharCode(event.charCode);

    if (!pattern.test(inputChar)) {
      // invalid character, prevent input
      event.preventDefault();
    }

    const latestValue = this.selectedUrbanIndicator + inputChar;
    if (latestValue.length > 10) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  onSubmit() {
    // console.log('Inside of StationMaintenanceAddZipCodeComponent.onSubmit()!');

    if (this.existentZipCode) {
      // console.log('   No Submit because existentZipCode = ' + this.existentZipCode);
      return;
    }

    // console.log(
    //   '   Submit to be done because existentZipCode = ' + this.existentZipCode
    // );

    let activeValue = false;
    if (this.selectedActive === 'Yes') {
      activeValue = true;
    }

    const body = {
      appUserName: sessionStorage.getItem('userName'),
      vaFacilityCd: this.aStation.stationId,
      zip_code: this.selectedZipCode,
      urban_indicator: this.selectedUrbanIndicator,
      fips_county_code: this.selectedFipsCountyCode,
      fips_state_code: this.selectedFipsStateCode,
      active: activeValue
    };

    // Debug Code
    // body.zip_code = '32765';
    // console.log('   request body = ' + JSON.stringify(body));

    this.addZipCodeErrorMessage = '';

    this.stationMaintenanceAddZipCodeService
      .zipCodeSave(body)
      .subscribe(data => {
        // console.log('   response data = ' + JSON.stringify(data));
        // console.log('   response data = ' + data);

        if (data.result) {
          this.editStationService.setAddZipCodeSuccessMessage(
            'Add ZIP Code Success: ' + this.selectedZipCode
          );
          this.editStationService.setCurrentStation(
            this.receivedDataStation.station
          );
          this.router.navigate(['stationMaintanceEdit']);
        } else {
          this.addZipCodeErrorMessage = data.message;
        }
      });
  }

  onClickCancel() {
    // console.log('Inside of StationMaintenanceAddZipCodeComponent.onClickCancel()!');
    // console.log('   receivedDataStation = ' + JSON.stringify(this.receivedDataStation));

    this.editStationService.setCurrentStation(this.receivedDataStation.station);
    this.router.navigate(['stationMaintanceEdit']);
  }
}
