import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { DebugElement } from '@angular/core';
import { By } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';

import { Observable } from 'rxjs/Observable';

import { MenuComponent } from '../../../shared/menu/menu.component';
import { StationMaintenanceAddZipCodeComponent } from './station-maintenance-add-zip-code.component';
import { StationMaintenanceAddZipCodeService } from './station-maintenance-add-zip-code.service';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';
import { WindowRefService } from '../../../window-ref.service';

// Franklin Perez (10/18/20917): Used technique desribed in the
// https://stackoverflow.com/questions/43549861/unit-testing-and-mocking-a-service-with-di
// web page to Mock a Service.
class MockStationMaintenanceAddZipCodeService extends StationMaintenanceAddZipCodeService {
	constructor() {
		super(null);
	}

	station = {
        "stationId": "999",
        "shortName": "GENHOSP",
        "name": "General Hospital",
        "type": "HOSP",
        "visn": "9",
        "allowReroute": "true",
        "agedDefinition": "",
        "parentStation": "",
        "createdBy": "DNS   MBAIAH",
        "dateCreated": "01/01/2017 12:59 PM"
    };

	responseBody = null;

	setResponseBody(aResponseBody) {
		this.responseBody = aResponseBody;
	}

	zipCodeSave(body) {
		return new Observable(observer => observer.next(this.responseBody));
	}
}

describe('StationMaintenanceAddZipCodeComponent', () => {
  let component: StationMaintenanceAddZipCodeComponent;
  let fixture: ComponentFixture<StationMaintenanceAddZipCodeComponent>;
  let stationMaintenanceAddZipCodeService: MockStationMaintenanceAddZipCodeService;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ MenuComponent, StationMaintenanceAddZipCodeComponent ],
	  imports: [ /* RouterTestingModule, */
	  		RouterTestingModule.withRoutes([
          		{ path: 'login', component: StationMaintenanceAddZipCodeComponent /* faking this for "async" test cases to work */ }
        	]),
	  		FormsModule, HttpModule ],
	  providers: [ { provide: StationMaintenanceAddZipCodeService, useClass: MockStationMaintenanceAddZipCodeService },
	  		EditStationService, WindowRefService, MockStationMaintenanceAddZipCodeService ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(StationMaintenanceAddZipCodeComponent);
    component = fixture.componentInstance;

    // Franklin Perez (10/19/2017): Use the "TestBed.get" method to get the Mock Service - not "fixture.debugElement.injector.get".
	// stationMaintenanceAddZipCodeService = fixture.debugElement.injector.get(MockStationMaintenanceAddZipCodeService);
	stationMaintenanceAddZipCodeService = TestBed.get(StationMaintenanceAddZipCodeService);

    const userInfo = {
      'permissions': {
        'claimsMenu': {
          'paymentError': 'true',
          'unmatchedPayments': 'true',
          'inprocess': 'true',
          'aged': 'true',
          'searchClaim': 'true',
          'rejectClaims': 'true',
          'awaitingProcessing': 'true'
        },
        'reportsMenu': {
          'claimsAwaitingProcessing': 'true',
          'reroutedClaims': 'true',
          'claimsInprocessSummary': 'true',
          'vistAError': 'true',
          'claimsCompleted': 'true',
          'CPEReport': 'true',
          'claimsCompletedSummary': 'true',
          'claimsInprocess': 'true',
          'outOfSystemPaymentsSummary': 'true',
          'BPPR16': 'true',
          'outOfSystemPayments': 'true',
          'claimsAwaitingProcessingSummary': 'true',
          'feeReport': 'true'
        }
      }
    };

	sessionStorage.setItem('userInfo', JSON.stringify(userInfo));

    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('verify "Add ZIP Code" text field exists', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();
  });

  it('verify "Add ZIP Code" text field is a required field', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	expect(htmlElement.getAttribute("required")).not.toBeNull();
	expect(htmlElement.getAttribute("required")).toEqual("");
  });

  it('verify "Add ZIP Code" text field has initially an empty string value', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Add ZIP Code" text field has same value as the "selectedZipCode" variable', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	component.selectedZipCode = "90210";
	fixture.detectChanges();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("90210");
  });

  it('verify Active Indicator is a mandatory field by seeing that needed elements are present', () => {
	let activeOptionsYesRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsYes'));
	expect(activeOptionsYesRadionButtonDebugElement).toBeTruthy();
	let activeOptionsYesRadionButtonHtmlElement: HTMLElement = activeOptionsYesRadionButtonDebugElement.nativeElement;
	expect(activeOptionsYesRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("type")).toEqual("radio");
	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-control")).toEqual("activeOptions");
	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("name")).toEqual("activeOptions");
	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("value")).toEqual("Yes");

	let activeOptionsNoRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsNo'));
	expect(activeOptionsNoRadionButtonDebugElement).toBeTruthy();
	let activeOptionsNoRadionButtonHtmlElement: HTMLElement = activeOptionsNoRadionButtonDebugElement.nativeElement;
	expect(activeOptionsNoRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("type")).toEqual("radio");
	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-control")).toEqual("activeOptions");
	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("name")).toEqual("activeOptions");
	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("value")).toEqual("No");
  });

  it('verify Active Indicator initially has "Yes" value', () => {
	let activeOptionsYesRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsYes'));
	expect(activeOptionsYesRadionButtonDebugElement).toBeTruthy();
	let activeOptionsYesRadionButtonHtmlElement: HTMLElement = activeOptionsYesRadionButtonDebugElement.nativeElement;
	expect(activeOptionsYesRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	let activeOptionsNoRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsNo'));
	expect(activeOptionsNoRadionButtonDebugElement).toBeTruthy();
	let activeOptionsNoRadionButtonHtmlElement: HTMLElement = activeOptionsNoRadionButtonDebugElement.nativeElement;
	expect(activeOptionsNoRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	expect(component.selectedActive).toEqual("Yes");
  });

  // Franklin Perez (10/18/2017): I could not get the below to work correctly, so I had to use the methodolgy
  // shown in the subsequent Unit Test.
  /*
  it('verify Active Indicator value changes to "No" when the "No" Radio Button is pressed', () => {
	let activeOptionsYesRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsYes'));
	expect(activeOptionsYesRadionButtonDebugElement).toBeTruthy();
	let activeOptionsYesRadionButtonHtmlElement: HTMLElement = activeOptionsYesRadionButtonDebugElement.nativeElement;
	expect(activeOptionsYesRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	let activeOptionsNoRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsNo'));
	expect(activeOptionsNoRadionButtonDebugElement).toBeTruthy();
	let activeOptionsNoRadionButtonHtmlElement: HTMLElement = activeOptionsNoRadionButtonDebugElement.nativeElement;
	expect(activeOptionsNoRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	expect(component.selectedActive).toEqual("Yes");

	// Click on the "No" radio Button
	activeOptionsNoRadionButtonHtmlElement.click();
	fixture.detectChanges();

	// expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("No");
	// expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("No");
	expect(component.selectedActive).toEqual("No");
 });
 */

 // Franklin Perez (10/18/2017): I had to use the below methodogy to test the Test Case. Above methodolgy did not work.
 it('verify Active Indicator value changes to "No" when the "No" Radio Button is pressed', async(() => {
	let activeOptionsYesRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsYes'));
	expect(activeOptionsYesRadionButtonDebugElement).toBeTruthy();
	let activeOptionsYesRadionButtonHtmlElement: HTMLElement = activeOptionsYesRadionButtonDebugElement.nativeElement;
	expect(activeOptionsYesRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	let activeOptionsNoRadionButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#activeOptionsNo'));
	expect(activeOptionsNoRadionButtonDebugElement).toBeTruthy();
	let activeOptionsNoRadionButtonHtmlElement: HTMLElement = activeOptionsNoRadionButtonDebugElement.nativeElement;
	expect(activeOptionsNoRadionButtonHtmlElement).toBeTruthy();

	expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("Yes");

	expect(component.selectedActive).toEqual("Yes");

	fixture.whenStable().then(() => {
		// Click on the "No" radio Button
		activeOptionsNoRadionButtonHtmlElement.click();
		// fixture.detectChanges();

		// Franklin Perez (10/17/2017): For some strange reason, the below ALWAYS was "Yes" instead of the "No" expected.
		// expect(activeOptionsYesRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("No");
		// expect(activeOptionsNoRadionButtonHtmlElement.getAttribute("ng-reflect-model")).toEqual("No");

		// Franklin Perez (10/17/2017): Below did behave correctly!
		expect(component.selectedActive).toEqual("No");
	});
 }));

  it('verify "FIPS County Code" text field exists', () => {
	let fipsCountyCodeTextDebugElement: DebugElement = fixture.debugElement.query(By.css('#fipsCountyCode'));
	expect(fipsCountyCodeTextDebugElement).toBeTruthy();
	let fipsCountyCodeTextHtmlElement: HTMLElement = fipsCountyCodeTextDebugElement.nativeElement;
	expect(fipsCountyCodeTextHtmlElement).toBeTruthy();

	expect(fipsCountyCodeTextHtmlElement.getAttribute("type")).toEqual("text");
	expect(component.selectedFipsCountyCode).toEqual("");
  });

  it('verify "FIPS County Code" text field has initially an empty string value', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#fipsCountyCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
	expect(component.selectedFipsCountyCode).toEqual("");
  });

  it('verify "FIPS County Code" text field has same value as the "selectedFipsCountyCode" variable', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#fipsCountyCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	component.selectedFipsCountyCode = "999";
	fixture.detectChanges();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("999");
  });

  it('verify "FIPS State Code" text field exists', () => {
	let fipsStateCodeTextDebugElement: DebugElement = fixture.debugElement.query(By.css('#fipsStateCode'));
	expect(fipsStateCodeTextDebugElement).toBeTruthy();
	let fipsStateCodeTextHtmlElement: HTMLElement = fipsStateCodeTextDebugElement.nativeElement;
	expect(fipsStateCodeTextHtmlElement).toBeTruthy();

	expect(fipsStateCodeTextHtmlElement.getAttribute("type")).toEqual("text");
	expect(component.selectedFipsStateCode).toEqual("");
  });

  it('verify "FIPS State Code" text field has initially an empty string value', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#fipsStateCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
	expect(component.selectedFipsCountyCode).toEqual("");
  });

  it('verify "FIPS State Code" text field has same value as the "selectedFipsStateCode" variable', () => {
	let debugElement: DebugElement = fixture.debugElement.query(By.css('#fipsStateCode'));
	let htmlElement: HTMLElement = debugElement.nativeElement;
	expect(htmlElement).toBeTruthy();

	component.selectedFipsStateCode = "CA";
	fixture.detectChanges();

	expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("CA");
  });

	it('verify "Urban Indicator" text field exists', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#urbanIndicator'));
		expect(debugElement).toBeTruthy();
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();

		expect(htmlElement.getAttribute("type")).toEqual("text");
		expect(component.selectedUrbanIndicator).toEqual("");
	});

	it('verify "Urban Indicator" text field has initially an empty string value', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#urbanIndicator'));
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();

		expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
		expect(component.selectedUrbanIndicator).toEqual("");
	});

	it('verify "Urban Indicator" text field has same value as the "selectedUrbanIndicator" variable', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#urbanIndicator'));
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();

		component.selectedUrbanIndicator = "C123456789";
		fixture.detectChanges();

		expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("C123456789");
	});

	it('verify Cancel button exists', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
		expect(debugElement).toBeTruthy();
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
	});

  	it('should call "onClickCancel" method when Cancel button is clicked', async(() => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
		let htmlElement: HTMLElement = debugElement.nativeElement;

		spyOn(component, 'onClickCancel');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(component.onClickCancel).toHaveBeenCalled();
		});
  	}));

	it('should route to "stationMaintanceEdit" url when Cancel button is clicked', async(() => {

		const debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		const navigateSpy = spyOn((<any>component).router, 'navigate');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(navigateSpy).toHaveBeenCalledWith(['stationMaintanceEdit']);
		})
	}));

  	it('verify Save button exists', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		expect(debugElement).toBeTruthy();
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
  	});

  	it('should call "onSubmit" method when Save button is clicked', async(() => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		let htmlElement: HTMLElement = debugElement.nativeElement;

		spyOn(component, 'onSubmit');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(component.onSubmit).toHaveBeenCalled();
		});
  	}));

	it('should route to "stationMaintanceEdit" url when Save button is clicked and successful addition of ZIP Code has been made', async(() => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = { "result": "Added ZIP Code"};
		stationMaintenanceAddZipCodeService.setResponseBody(responseBody);

		const navigateSpy = spyOn((<any>component).router, 'navigate');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(navigateSpy).toHaveBeenCalledWith(['stationMaintanceEdit']);
		})
	}));

	// Franklin Perez (10/19/2017): Below Test Case code did not work, and I had to use the subsequent one.
    /*
	it('should display appropriate Error Message when Save button is clicked and ZIP Code not added', async(() => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = { "message": "ZIP Code error Meesage"};
		stationMaintenanceAddZipCodeService.setResponseBody(responseBody);

		htmlElement.click();

		fixture.whenStable().then(() => {
			const addZipErrorMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#addZipCodeErrorMessage'));
			// expect(addZipErrorMessageDebugElement).toBeTruthy();

			console.log("   component.addZipCodeErrorMessage = " + component.addZipCodeErrorMessage);
		})
	}));
	*/

    // Franklin Perez (10/19/2017): Below Teest Case code work properly, and I could not use the above one.
 	it('should display appropriate Error Message when Save button is clicked and ZIP Code not added', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = { "message": "ZIP Code error Meesage"};
		stationMaintenanceAddZipCodeService.setResponseBody(responseBody);

		htmlElement.click();
		fixture.detectChanges();

		let addZipErrorMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#addZipCodeErrorMessage'));
		expect(addZipErrorMessageDebugElement).toBeTruthy();
		let addZipErrorMessageHtmlElement: HTMLElement = addZipErrorMessageDebugElement.nativeElement;
		expect(addZipErrorMessageHtmlElement).toBeTruthy();

		expect(addZipErrorMessageHtmlElement.innerText).toEqual(responseBody.message);
		expect(component.addZipCodeErrorMessage).toEqual(responseBody.message);;
  	});

});
