import { Injectable } from '@angular/core';
import 'rxjs/add/operator/map';
import { Observable } from 'rxjs/Observable';
import { RequestOptions, URLSearchParams, Headers, Response, Http } from '@angular/http';
import { environment } from '../../../../../environments/environment';

@Injectable()
export class AddStationService {
	constructor(private http: Http) { }

	public getAllVisn(
		requestOptions: RequestOptions
	): Observable<any[]> {
		return this.executeRestForUrl(
			environment.nodeserver + '/tools/addStation/visns',
			requestOptions
		);
	}

	public getAllType(
		requestOptions: RequestOptions
	): Observable<any[]> {
		return this.executeRestForUrl(
			environment.nodeserver + '/tools/addStation/types',
			requestOptions
		);
	}

	public addFacility(requestBody) {
		console.log('sending request to the node for claims');
		return this.http
			.post(environment.nodeserver + '/tools/addStation/addFacility', requestBody)
			.map((res: Response) => res.json());
	}

	public executeRestForUrl(
		url: string,
		requestOptions: RequestOptions
	): Observable<any[]> {
		const responseData = this.http
			.get(url, requestOptions)
			.map((res: Response) => <any[]>res.json());
		return responseData;
	}

	stationCheck(station) {
		console.log('station Service.ts ', station)
		return this.http.get(`${environment.nodeserver}/tools/addStation/stationCheck/${station}`)
			.map((response: Response) => response.json());
	}
}
