import { Component, OnInit, Output, EventEmitter } from '@angular/core';
import { AddStationParams } from './add-station.model';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Router } from '@angular/router';

import { AddStationService } from './service/add-station.service';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';

@Component({
  selector: 'app-add-station',
  templateUrl: './add-station.component.html',
  styleUrls: ['./add-station.component.scss']
})
export class AddStationComponent implements OnInit {
  @Output() notify = new EventEmitter<boolean>();
  formParams: AddStationParams;
  headers: Headers;
  visns: any[];
  types: any[];
  visnCodes: any[] = [];
  typeCodes: any[] = [];
  msg: string;
  btnClicked = false;
  success: boolean;
  currentStation; // current station that user is trying to add.
  existentStation = false; // boolean that will toggle once user enters a station.
  // *start* do not remove karma testing
  stationNo = { station_number: '4567' }; // task#589260
  shortName = { short_name: 'VAMC' }; // task#589343
  stationName = { name: 'VAMC-12345' }; // task#589344
  ageDefinition = { age: '30' }; // task#589345
  parentStation = { station: 'VAMC-12' }; // task#589348
  // *end*

  constructor(
    public router: Router,
    private addStationService: AddStationService,
    private editStationService: EditStationService
  ) {}

  ngOnInit() {
    this.formParams = new AddStationParams();
    this.headers = new Headers();
    this.getVisns();
    this.getType();
  }

  getVisns() {
    const options = new RequestOptions({ headers: this.headers });
    this.addStationService.getAllVisn(options).subscribe(
      data => {
        // console.log(JSON.stringify(data));
        this.visns = data;

        this.visns.forEach(visn => {
          const visncode: number = visn.visnIdCd;
          const description: string = 'VISN - ' + visncode;

          this.visnCodes.push({ code: visncode, description: description });
        });
      },
      error => alert(error)
    );
  }

  getType() {
    const options = new RequestOptions({ headers: this.headers });
    this.addStationService.getAllType(options).subscribe(
      data => {
        this.types = data;

        this.types.forEach(type => {
          const typeDisplayString: string =
            type.vaTypeCd + ' - ' + type.description;

          this.typeCodes.push({
            code: type.vaTypeCd,
            description: typeDisplayString
          });
        });
      },
      error => alert(error)
    );
  }

  onSubmit() {
    this.formParams.appUserName = sessionStorage.getItem('userName');
    const options = new RequestOptions({
      headers: this.headers,
      body: this.formParams
    });

    this.addStationService.addFacility(options).subscribe(
      data => {
        this.displayConfirmation(data.result);
        this.editStationService.onNotify({
          message: `Station ${this.formParams
            .vaFacilityCd} was successfully created.`,
          boolean: true
        });
        this.router.navigate([`viewStation/${this.formParams.vaFacilityCd}`]);
      },
      error => alert(error),
      () => console.log()
    );
    // this.setCurrentStation(this.formParams)
  }

  displayConfirmation(result: any) {
    this.btnClicked = true;
    if (result !== null || result !== undefined) {
      if (result === 1) {
        this.msg = result + ' Station added successfully';
        this.success = true;
      }
    } else {
      // console.log('Total this.message is null');
    }
  }
  // onStationEdit() {
  //   this.editStationService.setCurrentStation(this.formParams);
  //   this.router.navigate(['stationMaintanceEdit']);
  // }

  // method to check if a station was previously created.
  onStationCheck(station) {
    if (station && this.currentStation !== station) {
      this.addStationService.stationCheck(station).subscribe(response => {
        // console.log("this is responce", response);
        if (response.errorCode) {
          this.existentStation = true;
        } else {
          this.existentStation = false;
        }
      });
    }
  }

  onCancel() {
    this.existentStation = false;
  }
  // response.result = false 'does not exist'; no error
  // response.result = undefined 'error' = true; erro mission abort
}
