import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from '../../../shared/menu/menu.component';
import { AddStationComponent } from './add-station.component';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { TableComponent } from '../../../shared/table/table.component';
import { AssignComponent } from '../../../shared/assign/assign.component';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';
import { WindowRefService } from '../../../../app/window-ref.service';

describe('AddStationComponent', () => {
	let component: AddStationComponent;
	let fixture: ComponentFixture<AddStationComponent>;

	beforeEach(async(() => {
		TestBed.configureTestingModule({
			imports: [FormsModule, HttpModule, RouterTestingModule],
			declarations: [AddStationComponent, MenuComponent],
			providers: [WindowRefService, EditStationService]
		})
			.compileComponents();
	}));

	beforeEach(() => {
		fixture = TestBed.createComponent(AddStationComponent);
		component = fixture.componentInstance;
		fixture.detectChanges();
	});

	it('should be created', () => {
		expect(component).toBeTruthy();
	});

	//task#589260
	it('should have "station_number" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#station_number'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//karma unit test task-#589260
	it('should set input value for station_number', () => {
		// first round of change detection
		fixture.detectChanges();

		// get ahold of the input
		const input = fixture.debugElement.query(By.css('#station_number'));
		const inputElement = input.nativeElement;

		//set input value
		inputElement.value = '4567';
		inputElement.dispatchEvent(new Event('input'));

		expect(component.stationNo.station_number).toBe('4567');
	});

	//task#589342
	it('should have "visn" select element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('select'));
		const htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//task#589342
	it('should have "visn" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#visn'));
		const htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//task#589299
	it('should have VISN "type" select element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('select'));
		const htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//task#589299
	it('should have VISN "type" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#type'));
		const htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//task#589343
	it('should have "short_name" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#short_name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//karma unit test task-#589343
	it('should set input value for short_name', () => {
		// first round of change detection
		fixture.detectChanges();

		// get ahold of the input
		const input = fixture.debugElement.query(By.css('#short_name'));
		const inputElement = input.nativeElement;

		//set input value
		inputElement.value = 'VAMC';
		inputElement.dispatchEvent(new Event('input'));

		expect(component.shortName.short_name).toBe('VAMC');
	});

	//task#589344
	it('should have Station "name" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//karma unit test task-#589344
	it('should set input value for Station name', () => {
		// first round of change detection
		fixture.detectChanges();

		// get ahold of the input
		const input = fixture.debugElement.query(By.css('#name'));
		const inputElement = input.nativeElement;

		//set input value
		inputElement.value = 'VAMC-12345';
		inputElement.dispatchEvent(new Event('input'));

		expect(component.stationName.name).toBe('VAMC-12345');
	});

	//task#589345
	it('should have "age" definition element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#age'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//karma unit test task-#589345
	it('should set input value for Age Definition', () => {
		// first round of change detection
		fixture.detectChanges();

		// get ahold of the input
		const input = fixture.debugElement.query(By.css('#age'));
		const inputElement = input.nativeElement;

		//set input value
		inputElement.value = '30';
		inputElement.dispatchEvent(new Event('input'));

		expect(component.ageDefinition.age).toBe('30');
	});

	//task#589348
	it('should have parent "station" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#station'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	//karma unit test task-#589348
	it('should set input value for parent station', () => {
		// first round of change detection
		fixture.detectChanges();

		// get ahold of the input
		const input = fixture.debugElement.query(By.css('#station'));
		const inputElement = input.nativeElement;

		//set input value
		inputElement.value = 'VAMC-12';
		inputElement.dispatchEvent(new Event('input'));

		expect(component.parentStation.station).toBe('VAMC-12');
	});

});
