import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';

import { RequestOptions, URLSearchParams, Headers, Response, Http } from '@angular/http';
import { environment } from '../../../../environments/environment';

@Injectable()
export class StationMaintenanceAddContactInfoService {

    station = { };

    constructor(private http: Http) { }

    setStation(station) {
       this.station = station;
    }

    getStation(): Observable<any> {
       return new Observable(observer => observer.next(this.station));
    }

    contactInfoSave(body) {
		return this.http.post(`${environment.nodeserver}/tools/addContactInfo/contactInfoSave`, body)
			.map((response: Response) => response.json());
	}
}
