import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { StationMaintenanceAddContactInfoService } from './station-maintenance-add-contact-info.service';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';

@Component({
  selector: 'app-station-maintenance-add-contact-info',
  templateUrl: './station-maintenance-add-contact-info.component.html',
  styleUrls: ['./station-maintenance-add-contact-info.component.scss']
})
export class StationMaintenanceAddContactInfoComponent implements OnInit {
  receivedDataStation = null;
  aStation = null;

  addContactInfoErrorMessage = [];
  // contactTypeList = [ ];

  selectedContactName = '';
  selectedContactType = '';
  selectedAddressLineOne = '';
  selectedAddressLineTwo = '';
  selectedCity = '';
  selectedZipCode = '';
  selectedEmail = '';
  selectedFax = '';
  selectedPhone = '';

  constructor(
    private stationMaintenanceAddContactInfoService: StationMaintenanceAddContactInfoService,
    private editStationService: EditStationService,
    private router: Router
  ) {}

  ngOnInit() {
    // console.log('Inside of StationMaintenanceAddContactInfoComponent.ngOnInit!');

    this.stationMaintenanceAddContactInfoService
      .getStation()
      .subscribe(data => {
        // console.log('  data = ' + JSON.stringify(data));

        this.receivedDataStation = data;

        this.aStation = {
          stationId: '',
          shortName: '',
          name: '',
          type: '',
          visn: '',
          allowReroute: 'false',
          agedDefinition: '',
          parentStation: '',
          createdBy: '',
          dateCreated: ''
        };

        if (data.station) {
          this.aStation.stationId = data.station;
        }

        if (data.shortName) {
          this.aStation.shortName = data.shortName;
        }

        if (data.stationName) {
          this.aStation.name = data.stationName;
        }

        if (data.stationType) {
          this.aStation.type = data.stationType;
        }

        if (data.visnNumber) {
          this.aStation.visn = data.visnNumber;
        }

        if (data.allowReroute) {
          this.aStation.allowReroute = String(data.allowReroute);
        }

        if (data.agedDef) {
          this.aStation.agedDefinition = String(data.agedDef);
        }

        if (data.parentStation) {
          this.aStation.parentStation = data.parentStation;
        }

        if (data.createdBy) {
          this.aStation.createdBy = String(data.createdBy);
        }

        if (data.dateCreated) {
          this.aStation.dateCreated = data.dateCreated.split(' ')[0];
        }
      });

    // Franklin Perez (11/3/2017): As per Jose and Georrge, the "Contact Type" goes back
    //    to being a Text Field.
    /*
    this.editStationService.getTypes().subscribe(types => {
      this.contactTypeList = types;
      this.selectedContactType = this.contactTypeList[0].vaTypeCd;
    });
    */
  }

  contactNameKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedContactName + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  contactTypeKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedContactType + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  addressLineOneKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedAddressLineOne + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  addressLineTwoKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedAddressLineTwo + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  cityKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedCity + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  zipCodeKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedZipCode + inputChar;
    if (latestValue.length > 5) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  emailKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedEmail + inputChar;
    if (latestValue.length > 50) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  faxKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedFax + inputChar;
    if (latestValue.length > 12) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  phoneKeyPress(event: any) {
    const inputChar = String.fromCharCode(event.charCode);

    const latestValue = this.selectedPhone + inputChar;
    if (latestValue.length > 12) {
      // invalid number of characters, prevent input
      event.preventDefault();
    }
  }

  onSubmit() {
    // console.log('Inside of StationMaintenanceAddContactInfoComponent.onSubmit()!');

    const body = {
      appUserName: sessionStorage.getItem('userName'),
      // 'vaFacility': this.aStation.stationId, // Debugging purposes only. Will cause an Error Response
      vaFacilityCd: this.aStation.stationId,
      contactType: this.selectedContactType,
      contactName: this.selectedContactName,
      address1: this.selectedAddressLineOne,
      address2: this.selectedAddressLineTwo,
      city: this.selectedCity,
      zip: this.selectedZipCode,
      phone: this.selectedPhone,
      email: this.selectedEmail,
      fax: this.selectedFax
    };

    console.log('request body = ' + JSON.stringify(body));

    this.addContactInfoErrorMessage = [];

    this.stationMaintenanceAddContactInfoService
      .contactInfoSave(body)
      .subscribe(data => {
        // console.log('   response data = ' + JSON.stringify(data));
        // console.log('   response data = ' + data);

        if (data.result) {
          this.editStationService.setAddContactInfoSuccessMessage(
            'Add Contact Info: Successfully Created'
          );
          this.editStationService.setCurrentStation(
            this.receivedDataStation.station
          );
          this.router.navigate(['stationMaintanceEdit']);
        } else if (data.message) {
          this.addContactInfoErrorMessage.push(data);
        } else {
          this.addContactInfoErrorMessage = data;
        }
      });
  }

  onClickCancel() {
    // console.log('Inside of StationMaintenanceAddContactInfoComponent.onClickCancel()!');
    // console.log('   receivedDataStation = ' + JSON.stringify(this.receivedDataStation));

    this.editStationService.setCurrentStation(this.receivedDataStation.station);
    this.router.navigate(['stationMaintanceEdit']);
  }
}
