import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { DebugElement } from '@angular/core';
import { By } from '@angular/platform-browser';

import { FormsModule } from '@angular/forms';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';

import { Observable } from 'rxjs/Observable';

import { MenuComponent } from '../../../shared/menu/menu.component';

import { StationMaintenanceAddContactInfoComponent } from './station-maintenance-add-contact-info.component';

import { StationMaintenanceAddContactInfoService } from './station-maintenance-add-contact-info.service';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';
import { WindowRefService } from '../../../window-ref.service';

// Franklin Perez (10/30/20917): Used technique desribed in the
// https://stackoverflow.com/questions/43549861/unit-testing-and-mocking-a-service-with-di
// web page to Mock a Service.
class MockStationMaintenanceAddContactInfoService extends StationMaintenanceAddContactInfoService {
	constructor() {
		super(null);
	}

	station = {
        "stationId": "999",
        "shortName": "GENHOSP",
        "name": "General Hospital",
        "type": "HOSP",
        "visn": "9",
        "allowReroute": "true",
        "agedDefinition": "",
        "parentStation": "",
        "createdBy": "DNS   MBAIAH",
        "dateCreated": "01/01/2017 12:59 PM"
    };

	responseBody = null;

	setResponseBody(aResponseBody) {
		this.responseBody = aResponseBody;
	}

	contactInfoSave(body) {
		return new Observable(observer => observer.next(this.responseBody));
	}
}

describe('StationMaintenanceAddContactInfoComponent', () => {
  let component: StationMaintenanceAddContactInfoComponent;
  let fixture: ComponentFixture<StationMaintenanceAddContactInfoComponent>;
  let stationMaintenanceAddContactInfoService: MockStationMaintenanceAddContactInfoService;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ MenuComponent, StationMaintenanceAddContactInfoComponent ],
      imports: [ /* RouterTestingModule, */
	  		RouterTestingModule.withRoutes([
          { path: 'login', component: StationMaintenanceAddContactInfoComponent /* faking this for "async" test cases to work */ }
        ]), 
        HttpModule, FormsModule ],
      providers: [ { provide: StationMaintenanceAddContactInfoService, useClass: MockStationMaintenanceAddContactInfoService }, 
        WindowRefService,  EditStationService ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(StationMaintenanceAddContactInfoComponent);
    component = fixture.componentInstance;

    // Franklin Perez (10/30/2017): Use the "TestBed.get" method to get the Mock Service - not "fixture.debugElement.injector.get".
	  // stationMaintenanceAddZipCodeService = fixture.debugElement.injector.get(MockStationMaintenanceAddZipCodeService);
	  stationMaintenanceAddContactInfoService = TestBed.get(StationMaintenanceAddContactInfoService);
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('verify "Contact Name" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactName'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Contact Name" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactName'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Contact Name" text field has same value as the "selectedContactName" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactName'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedContactName = "George Takay";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedContactName);
  });

  it('verify "Contact Type" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactType'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Contact Type" text field is a required field', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactType'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("required")).not.toBeNull();
    expect(htmlElement.getAttribute("required")).toEqual("");
  });

  it('verify "Contact Type" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactType'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Contact Type" text field has same value as the "selectedContactType" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#contactType'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedContactName = "ADDRESS";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedContactType);
  });

  it('verify "Address Line 1" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineOne'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Address Line 1" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineOne'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Address Line 1" text field has same value as the "selectedAddressLineOne" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineOne'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedAddressLineOne = "123 Elm Street";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedAddressLineOne);
  });

  it('verify "Address Line 2" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineTwo'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Address Line 2" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineTwo'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Address Line 2" text field has same value as the "selectedAddressLineTwo" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#addressLineTwo'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedAddressLineTwo = "Suite 12345";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedAddressLineTwo);
  });

  it('verify "City" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#city'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "City" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#city'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "City" text field has same value as the "selectedCity" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#city'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedCity = "Melbourne";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedCity);
  });

  it('verify "Zip" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Zip" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Zip" text field has same value as the "selectedZipCode" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#zipCode'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedZipCode = "90210";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedZipCode);
  });

  it('verify "Email" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Email" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Email" text field has same value as the "selectedEmail" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedEmail = "larry@livemail.com";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedEmail);
  });

  it('verify "Fax" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#fax'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Fax" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Fax" text field has same value as the "selectedFax" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#fax'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedFax = "321-678-1110";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedFax);
  });

  it('verify "Phone" text field exists', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();

    expect(htmlElement.getAttribute("type")).toEqual("text");
    expect(htmlElement.tagName).toEqual("INPUT");
  });

  it('verify "Phone" text field has initially an empty string value', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual("");
  });

  it('verify "Phone" text field has same value as the "selectedPhone" variable', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
    expect(debugElement).toBeTruthy();
    let htmlElement: HTMLElement = debugElement.nativeElement;
    expect(htmlElement).toBeTruthy();
  
    component.selectedPhone = "321-678-2000";
    fixture.detectChanges();
  
    expect(htmlElement.getAttribute("ng-reflect-model")).toEqual(component.selectedPhone);
  });

	it('verify Cancel button exists', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
		expect(debugElement).toBeTruthy();
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
  });
  
  it('should call "onClickCancel" method when Cancel button is clicked', async(() => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
		let htmlElement: HTMLElement = debugElement.nativeElement;

		spyOn(component, 'onClickCancel');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(component.onClickCancel).toHaveBeenCalled();
		});
  }));

	it('should route to "stationMaintanceEdit" url when Cancel button is clicked', async(() => {
    
    const debugElement: DebugElement = fixture.debugElement.query(By.css('#cancel'));
    const htmlElement: HTMLElement = debugElement.nativeElement;
    
    const navigateSpy = spyOn((<any>component).router, 'navigate');
    
    htmlElement.click();
    
    fixture.whenStable().then(() => {
      expect(navigateSpy).toHaveBeenCalledWith(['stationMaintanceEdit']);
    })
  }));

  it('verify Save button exists', () => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		expect(debugElement).toBeTruthy();
		let htmlElement: HTMLElement = debugElement.nativeElement;
		expect(htmlElement).toBeTruthy();
  });

  it('should call "onSubmit" method when Save button is clicked', async(() => {
		let debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		let htmlElement: HTMLElement = debugElement.nativeElement;

		spyOn(component, 'onSubmit');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(component.onSubmit).toHaveBeenCalled();
		});
  }));

	it('should route to "stationMaintanceEdit" url when Save button is clicked and successful addition of Contact Info has been made', async(() => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = { "result": true };
		stationMaintenanceAddContactInfoService.setResponseBody(responseBody);

		const navigateSpy = spyOn((<any>component).router, 'navigate');

		htmlElement.click();

		fixture.whenStable().then(() => {
			expect(navigateSpy).toHaveBeenCalledWith(['stationMaintanceEdit']);
		})
  }));

  it('should display appropriate Error Message when Save button is clicked and Business Logic validation error occurs', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = { "errorCode": "Add Contact Info error", "message": "Va Facility '999' is not found" };
		stationMaintenanceAddContactInfoService.setResponseBody(responseBody);

		htmlElement.click();
		fixture.detectChanges();

		let addContactInfoErrorMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#addContactInfoErrorMessage'));
		expect(addContactInfoErrorMessageDebugElement).toBeTruthy();
		let addContactInfoErrorMessageHtmlElement: HTMLElement = addContactInfoErrorMessageDebugElement.nativeElement;
		expect(addContactInfoErrorMessageHtmlElement).toBeTruthy();

    expect(component.addContactInfoErrorMessage.length).toEqual(1);
    expect(addContactInfoErrorMessageHtmlElement.innerText).toContain(responseBody.errorCode);
    expect(addContactInfoErrorMessageHtmlElement.innerText).toContain(responseBody.message);
  });

  it('should display appropriate Error Message when Save button is clicked and Request Body validation error occurs', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#save'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		let responseBody = [ { "errorCode": "ERR", "entity": "vaFacilityCd", "message": "may not be null" } ]
		stationMaintenanceAddContactInfoService.setResponseBody(responseBody);

		htmlElement.click();
		fixture.detectChanges();

		let addContactInfoErrorMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#addContactInfoErrorMessage'));
		expect(addContactInfoErrorMessageDebugElement).toBeTruthy();
		let addContactInfoErrorMessageHtmlElement: HTMLElement = addContactInfoErrorMessageDebugElement.nativeElement;
		expect(addContactInfoErrorMessageHtmlElement).toBeTruthy();

    expect(component.addContactInfoErrorMessage.length).toEqual(1);
    expect(addContactInfoErrorMessageHtmlElement.innerText).toContain(responseBody[0].errorCode);
    expect(addContactInfoErrorMessageHtmlElement.innerText).toContain(responseBody[0].entity);
    expect(addContactInfoErrorMessageHtmlElement.innerText).toContain(responseBody[0].message);
  });

});
