import {
  Component,
  AfterContentInit,
  Input,
  ViewChild,
  EventEmitter
} from '@angular/core';
import { NgForm } from '@angular/forms';
import { RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Rx';

import { UserRequestSearch } from '../models/user-request-search.model';
import { RestService } from '../../shared/service/rest.service';
import { environment } from '../../../environments/environment';
import { TableComponent } from '../../shared/table/table.component';
import { ColumnMetadata } from '../../shared/table/cols.model';
import { TableOptions } from '../../shared/table/table-options.model';
import { TableService } from '../../shared/table/table.service';

@Component({
  selector: 'search-user-request',
  templateUrl: 'search-user-request.component.html',
  styleUrls: ['search-user-request.component.scss'],
  providers: [RestService, TableService]
})
export class SearchUserRequestComponent implements AfterContentInit {
  f: NgForm;
  @ViewChild('f') currentForm: NgForm;
  userRequest: UserRequestSearch = new UserRequestSearch();
  message: String = '';
  winntname = { userName: 'vhaispchmiem' }; // task#583257
  firstName = { firstName: 'Lucky' }; // karma unit test task-#583318
  stationID = { stationId: '123' }; // karma test - task#588319
  lastName = { lastName: 'chan' }; // karma test - task#583320
  phoneNumber = { phone: '9778654321' }; // karma test - task#583321
  emailAddress = { email: PII        ' }; // karma test for email element task#583322
  loading = false;
  results = [];
  tableOptions = new TableOptions()
    .setNoNumPerPage(true)
    .setNoPagination(true)
    .setNoShowMessages(true)
    .setNoShowNumResults(true);
  public cols: ColumnMetadata[] = [
    new ColumnMetadata('userName', 'NT Username'),
    new ColumnMetadata('lastName', 'Last Name'),
    new ColumnMetadata('firstName', 'First Name'),
    new ColumnMetadata('active', 'Active'),
    new ColumnMetadata('lastLogin', 'Last Login').setAlign('right'),
    new ColumnMetadata('phone', 'Phone').setAlign('right'),
    new ColumnMetadata('email', 'Email'),
    new ColumnMetadata('edit', '')
      .setSort(false)
      .setButton(true)
      .setAlign('center')
  ];

  constructor(public rest: RestService) {}

  ngAfterContentInit() {
    this.onSubmit();
  }
  onSubmit() {
    this.loading = true;
    const options = new RequestOptions({ body: this.userRequest });
    this.rest
      .postObjectFromUrl<any>(
        environment.nodeserver + '/tools/userRequest/search',
        options
      )
      .subscribe(data => {
        this.message = data.result === 1 ? 'success' : data.error_description;
        if (!!data) {
          data.usersfromSearch.forEach(user => {
            user.edit = 'Edit';
            user.editLink = '/modifyUserRequest/' + user.userName;
          });
          this.results = data.usersfromSearch;
          this.loading = false;
        }
      });
  }
}
