import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from '../../shared/menu/menu.component';
import { SearchUserRequestComponent } from './search-user-request.component';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { TableComponent } from '../../shared/table/table.component';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { AssignComponent } from '../../shared/assign/assign.component';


describe('SearchUserRequestComponent', () => {
    let component: SearchUserRequestComponent;
    let fixture: ComponentFixture<SearchUserRequestComponent>;
    let debugElement: DebugElement;

    beforeEach(async(() => {
        TestBed.configureTestingModule({
            imports: [FormsModule, HttpModule, RouterTestingModule],
            declarations: [SearchUserRequestComponent, MenuComponent, TableComponent, AssignComponent, PaginationComponent, NumPerPageComponent]
        })
            .compileComponents();
    }));

    beforeEach(() => {
        fixture = TestBed.createComponent(SearchUserRequestComponent);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    it('should be created', () => {
        expect(component).toBeTruthy();
    });

    //task#583257
    it('should have "userName" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#userName'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

    //task#583257
    it('should set input value for userName', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input  component.userRequest.disable_comments = "some text";
        //let input = debugElement.query(By.css('#window_nt_name'));
        const input = fixture.debugElement.query(By.css('#userName'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'vhaispchmiem';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.winntname.userName).toBe('vhaispchmiem');
    });

    //karma unit test task-#583318
    it('should have "firstName" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#firstName'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

    //karma unit test task-#583318 
    it('should set input value for firstName', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#firstName'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'Lucky';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.firstName.firstName).toBe('Lucky');
    });

    //karma test - task#588319
    it('should have "stationId element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#stationId'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#588319
    it('should set input value for stationId', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#stationId'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = '123';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.stationID.stationId).toBe('123');
    });

    //karma test - task#583320
    it('should have "lastName" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#lastName'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#583320
    it('should set input value for lastName', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#lastName'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'chan';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.lastName.lastName).toBe('chan');
    });

    //karma test - task#583321
    it('should have "phone number element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#583321
    it('should set input value for phone number element', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#phone'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = '9778654321';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.phoneNumber.phone).toBe('9778654321');
    });

    // karma test for email element task#583322
    it('should have email element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    // karma test for email element task#583322
    it('should set input value for email address element', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#email'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = PII        ';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.emailAddress.email).toBe('ABC@DOMAIN');
    });

    // karma test for email element task#583323
    it('should have cols created', () => {
        expect(component.cols).toBeTruthy();
    });

    // karma test for email element task#583323
    it('should have tableOptions created', () => {
        expect(component.tableOptions).toBeTruthy();
    });

    // karma test for Search button element task#583324
    it('should have Search button element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#search'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

});
