import { Component, OnInit, Input, ViewChild, EventEmitter } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { RequestOptions } from '@angular/http';

import { UserRequest } from '../models/userRequest';
import { RestService } from '../../shared/service/rest.service';
import { AssignComponent } from '../../shared/assign/assign.component';
import { environment } from '../../../environments/environment';
import { Observable } from 'rxjs/Rx';

@Component({
	selector: "modify-user-request",
	templateUrl: "modify-user-request.component.html",
	styleUrls: ["modify-user-request.component.scss"],
	providers: [RestService]
})

export class ModifyUserRequestComponent implements OnInit {
	f: NgForm;
	@ViewChild('f') currentForm: NgForm;
	userRequest: UserRequest = new UserRequest();
	roles: String[];
	facilities: String[];
	message: String = '';
	originalEnabled: boolean = this.userRequest.enabled;
	winntname = { window_nt_name: 'vhaispchmiem' }; //karma unit test task#578136
	firstName = { first_name: 'Lucky' };//karma unit test task-#581416
	comments = { disable_comments: 'not validated' };//karma test - task# 580349
	middleName = { middle_name: 'jackie' };//karma test - task#580196
	lastName = { last_name: 'chan' };//karma test - task#580881
	phoneNumber = { phone: '9778654321' };//karma test - task#580342
	emailAddress = { email: PII        ' };// karma test for email element task#581091


	constructor(public rest: RestService, private activatedRoute: ActivatedRoute) { }

	ngOnInit() {


		this.rest.getObjectFromUrl<any>(environment.nodeserver + '/tools/userRequest/' + this.activatedRoute.snapshot.params.id).map(
			data => {
				if (!!data && !data.error_code) {
					this.userRequest = data;
					// removes the prepopulated duplicates from the left side
					this.roles = data.available_roles.filter(x => data.request_roles.indexOf(x) === -1);
					this.facilities = data.available_facilities.filter(x => data.request_facilities.indexOf(x) === -1);

					// all fields will be marked dirty, forcing a validation on the new prepopulated data
					for (var i in this.currentForm.controls) {
						this.currentForm.controls[i].markAsDirty();
					}
				} else if (!!data.error_code) {
					console.log(data.error_code + ' : ' + data.error_description);
				}
			}
		).subscribe(data => { });
	}

	onSubmit() {
		this.userRequest.current_user_name = sessionStorage.getItem('userName');
		const options = new RequestOptions({ body: this.userRequest }); console.log('body is' + options);
		this.rest.putObjectFromUrl<any>(environment.nodeserver + '/tools/userRequest/', options).subscribe(
			data => { this.message = data.result === 1 ? 'success' : data.error_description; console.log(JSON.stringify(data)); }
		);
	}
}
