import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from '../../shared/menu/menu.component';
import { ModifyUserRequestComponent } from './modify-user-request.component';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { TableComponent } from '../../shared/table/table.component';
import { AssignComponent } from '../../shared/assign/assign.component';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';

describe('ModifyUserRequestComponent', () => {
    let component: ModifyUserRequestComponent;
    let fixture: ComponentFixture<ModifyUserRequestComponent>;
    let debugElement: DebugElement;

    beforeEach(async(() => {
        TestBed.configureTestingModule({
            imports: [FormsModule, HttpModule, RouterTestingModule],
            declarations: [ModifyUserRequestComponent, MenuComponent, TableComponent, AssignComponent, PaginationComponent, NumPerPageComponent]
        })
            .compileComponents();
    }));

    beforeEach(() => {
        fixture = TestBed.createComponent(ModifyUserRequestComponent);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    it('should be created', () => {
        expect(component).toBeTruthy();
    });

    //task#578136
    it('should have "window_nt_name" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#window_nt_name'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

    //task#578136
    it('should set input value for window_nt_name', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input  component.userRequest.disable_comments = "some text";
        //let input = debugElement.query(By.css('#window_nt_name'));
        const input = fixture.debugElement.query(By.css('#window_nt_name'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'vhaispchmiem';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.winntname.window_nt_name).toBe('vhaispchmiem');
    });

    //karma unit test task-#581416
    it('should have "first_name" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#first_name'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

    //karma unit test task-#581416 
    it('should set input value for first_name', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#first_name'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'Lucky';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.firstName.first_name).toBe('Lucky');
    });

    //karma test - task#580196
    it('should have "middle_name element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#middle_name'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#580196
    it('should set input value for middle_name', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#middle_name'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'jackie';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.middleName.middle_name).toBe('jackie');
    });

    //karma test - task#580881
    it('should have "last_name" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#last_name'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#580881
    it('should set input value for last_name', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#last_name'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'chan';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.lastName.last_name).toBe('chan');
    });

    //karma test - task#580342
    it('should have "phone number element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    //karma test - task#580342
    it('should set input value for phone number element', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#phone'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = '9778654321';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.phoneNumber.phone).toBe('9778654321');
    });

    // karma test for email element task#581091
    it('should have email element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    // karma test for email element task#581091
    it('should set input value for email address element', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#email'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = PII        ';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.emailAddress.email).toBe('ABC@DOMAIN');
    });

    // karma test for Enable/Disable checkbox task#580388
    it('enable/disable checkbox should be checked', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#enabled'));
        const htmlElement: HTMLElement = debugElement.nativeElement;
        let input: HTMLInputElement;
        input = fixture.debugElement.query(By.css('#enabled')).nativeElement;
        expect(input.checked.valueOf).toBeTruthy(); // valueOf attribute true indicates checkbox is checked
    });

    // karma test for Roles select box element task#581243
    it('should have Roles multiple select box element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE SUPERVISOR"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE SUPERVISOR')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE VISN PGM MANAGER"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE VISN PGM MANAGER')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FPPS ADMIN"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FPPS ADMIN')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FPPS HELP DESK"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FPPS HELP DESK')).toBeDefined();

    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE CLERK"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE CLERK')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE DATA ADMIN"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE DATA ADMIN')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE FISCAL USER"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE FISCAL USER')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE MAIL CLERK"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE MAIL CLERK')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "FEE HELP DESK"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('FEE HELP DESK')).toBeDefined();
    });

    // karma test for Roles select box element available option task#581243
    it('should have available Role OF "HAC DATA ADMIN"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('HAC DATA ADMIN')).toBeDefined();
    });

    // karma test for facilities select box element task#580265 facilities
    it('should have facilities select box element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });

    // karma test for facilities select box element task#580265
    it('should have available facility OF "Visn: 16/Facility: 580 (Houston VAMC)"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('Visn: 16/Facility: 580 (Houston VAMC)')).toBeDefined();

    });

    // karma test for facilities select box element task#580265
    it('should have available facility OF "Visn: 16/Facility: 564 (Fayetteville NC)"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('Visn: 16/Facility: 564 (Fayetteville NC)')).toBeDefined();

    });
    // karma test for facilities select box element task#580265
    it('should have available facility OF "Visn: 16/Facility: 586 (JACKSON MS)"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('Visn: 16/Facility: 586 (JACKSON MS)')).toBeDefined();

    });
    // karma test for facilities select box element task#580265
    it('should have available facility OF "Visn: 16/Facility: 598 (N LITTLE ROCK)"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('Visn: 16/Facility: 598 (N LITTLE ROCK)')).toBeDefined();

    });
    // karma test for facilities select box element task#580265
    it('should have available facility OF "Visn: 16/Facility: 563 (BILOXI MS)"', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement.attributes.getNamedItem('Visn: 16/Facility: 563 (BILOXI MS)')).toBeDefined();

    });
    //karma unit test task-#580349
    it('should have "disable_comments" element', () => {
        const debugElement: DebugElement = fixture.debugElement.query(By.css('#comments'));
        const htmlElement: HTMLElement = debugElement.nativeElement;

        expect(htmlElement).toBeTruthy();
        expect(htmlElement.hidden).toEqual(false);
        expect(htmlElement.hidden).toBe(false);

    });
    //karma unit test task-#580349 - second test
    it('should set input value for "disable_comments"', () => {
        // first round of change detection
        fixture.detectChanges();

        // get ahold of the input
        const input = fixture.debugElement.query(By.css('#comments'));
        const inputElement = input.nativeElement;

        //set input value
        inputElement.value = 'not validated';
        inputElement.dispatchEvent(new Event('input'));

        expect(component.comments.disable_comments).toBe('not validated');
    });



});
