import { Component, AfterViewInit, ViewChild } from '@angular/core';
import { environment } from '../../../environments/environment';
import { MedicalCodeLookup } from '../models/medical-code.model';
import { TableComponent } from '../../shared/table/table.component';
import { ColumnMetadata } from '../../shared/table/cols.model';

@Component({
  selector: 'app-medical-code-lookup',
  templateUrl: './medical-code-lookup.component.html',
  styleUrls: ['./medical-code-lookup.component.scss']
})
export class MedicalCodeLookupComponent implements AfterViewInit {
  public searchParam: MedicalCodeLookup = new MedicalCodeLookup();

  public cols: any[] = [
    new ColumnMetadata('codeType', 'Code Type').setAlign('right'),
    new ColumnMetadata('code', 'Medical Code').setAlign('right'),
    new ColumnMetadata('description', 'Description'),
    new ColumnMetadata('drugExempt', 'Drug Exempt'),
    new ColumnMetadata('startDate', 'Start Date').setAlign('right'),
    new ColumnMetadata('expirationDate', 'Expiration Date').setAlign('right')
  ];
  @ViewChild(TableComponent) tableComponent: TableComponent;
  constructor() {}

  ngAfterViewInit() {
    this.search();
  }

  search() {
    this.tableComponent.update();
  }
}
