import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from '../../shared/menu/menu.component';
import { MedicalCodeLookupComponent } from './medical-code-lookup.component';
import { RouterTestingModule } from '@angular/router/testing';
import { DebugElement } from '@angular/core';
import { By } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import { RestService } from '../../shared/service/rest.service';
import { HttpModule } from '@angular/http';
import { TableComponent } from '../../shared/table/table.component'
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { TableService } from '../../shared/table/table.service'

describe('MedicalCodeLookupComponent', () => {
  let component: MedicalCodeLookupComponent;
  let fixture: ComponentFixture<MedicalCodeLookupComponent>;

    beforeEach(async(() => {
        TestBed.configureTestingModule({
            imports: [RouterTestingModule, FormsModule, HttpModule],
            declarations: [MedicalCodeLookupComponent, MenuComponent, TableComponent, PaginationComponent, NumPerPageComponent],
            providers: [RestService, TableService]
        })
            .compileComponents();
    }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MedicalCodeLookupComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });
  it('should have a "Diagonosis Code Lookup" page title', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#title'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('should have a "Diagonosis Code Search Filter" sub-title', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#subTitle'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('should have "Diagnosis Code" input element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#medicalCode'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have "Code Type" input element', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#codeType'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });

  it('should have  "search" button enabled', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#search'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.getAttribute('disabled')).toBeNull();
  });

  it('should have  "clear" button Visible', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#clear'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy()
    expect(htmlElement.hidden).toEqual(false);
    expect(htmlElement.hidden).toBe(false);
  });
  it('should have a "Diagonosis Code Search Result" sub-title', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#tableTitle'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement.hidden).toBe(false);
    expect(htmlElement).toBeTruthy();
  });

  it('should have "table" displayed', () => {
    let debugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
    let htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
  });
});
