import { Component, AfterViewInit, ViewChild } from '@angular/core';
import { environment } from '../../../environments/environment';
import { DiagnosisCodeLookUp } from '../models/diagnosis-code.model';
import { TableComponent } from '../../shared/table/table.component';
import { ColumnMetadata } from '../../shared/table/cols.model';

@Component({
  selector: 'app-diagnosis-code-lookup',
  templateUrl: './diagnosis-code-lookup.component.html',
  styleUrls: ['./diagnosis-code-lookup.component.scss']
})
export class DiagnosisCodeLookupComponent {
  public searchParam: DiagnosisCodeLookUp = new DiagnosisCodeLookUp();

  public cols: any[] = [
    new ColumnMetadata('code', 'Diagnosis Code').setAlign('right'),
    new ColumnMetadata('description', 'Description'),
    new ColumnMetadata('codeType', 'Code Type').setAlign('right'),
    new ColumnMetadata('drugExempt', 'DRG Exempt Flag'),
    new ColumnMetadata('startDate', 'Start Date').setAlign('right'),
    new ColumnMetadata('expirationDate', 'Expiration Date').setAlign('right')
    // { 'name': 'Diagnosis Code', 'id': 'code' },
    // { 'name': 'Description', 'id': 'description' },
    // { 'name': 'Code Type', 'id': 'codeType' },
    // { 'name': 'DRG Exempt Flag', 'id': 'drugExempt' },
    // { 'name': 'Start Date', 'id': 'startDate' },
    // { 'name': 'Expiration Date', 'id': 'expirationDate' }
  ];
  @ViewChild(TableComponent) tableComponent: TableComponent;
  constructor() {}

  ngAfterViewInit() {
    this.search();
  }

  search() {
    this.tableComponent.update();
  }
}
