import { Component, OnInit, Input, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { RequestOptions } from '@angular/http';
import { UserRequest } from '../models/userRequest';
import { RestService } from '../../shared/service/rest.service';
import { AssignComponent } from '../../shared/assign/assign.component';
import { environment } from '../../../environments/environment';

@Component({
	selector: 'create-user-request',
	templateUrl: 'create-user-request.component.html',
	styleUrls: ['create-user-request.component.scss'],
	providers: [RestService]
})

export class CreateUserRequestComponent implements OnInit {
	f: NgForm;
	@ViewChild('f') currentForm: NgForm;
	userRequest: UserRequest = new UserRequest();
	roles: String[];
	facilities: String[];
	message: String = '';
	originalEnabled: boolean = this.userRequest.enabled;

	constructor(public rest: RestService) { }

	ngOnInit() {
		this.userRequest.current_user_name = sessionStorage.getItem('userName');
		this.rest.getObjectFromUrl<any>(environment.nodeserver + '/tools/userRequest/roles').subscribe(
			data => {
				this.roles = data.available_roles;
				this.facilities = data.available_facilities;
			}
		);
	}

	onSubmit() {
		const options = new RequestOptions({ body: this.userRequest });
		this.rest.postObjectFromUrl<any>(environment.nodeserver + '/tools/userRequest/', options).subscribe(
			data => this.message = data.result === 1 ? 'success' : data.error_description
		);
	}
}
