import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from '../../shared/menu/menu.component';
import { CreateUserRequestComponent } from './create-user-request.component';
import { RouterTestingModule } from '@angular/router/testing';
import { HttpModule } from '@angular/http';
import { FormsModule } from '@angular/forms';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';
import { TableComponent } from '../../shared/table/table.component';
import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
import { AssignComponent } from '../../shared/assign/assign.component';

describe('CreateUserRequestComponent', () => {
	let component: CreateUserRequestComponent;
	let fixture: ComponentFixture<CreateUserRequestComponent>;
	let input: Element;

    beforeEach(async(() => {
        TestBed.configureTestingModule({
            imports: [FormsModule, HttpModule, RouterTestingModule],
            declarations: [CreateUserRequestComponent, MenuComponent, TableComponent, AssignComponent, PaginationComponent, NumPerPageComponent]
        })
            .compileComponents();
    }));


	beforeEach(() => {
		fixture = TestBed.createComponent(CreateUserRequestComponent);
		component = fixture.componentInstance;
		fixture.detectChanges();
	});

	it('should be created', () => {
		expect(component).toBeTruthy();
	});

	it('should have "last_name" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#last_name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	// karma test for Enable/Disable checkbox task#574122 or 573798?
	it('checkbox should be checked', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#enabled'));
		const htmlElement: HTMLElement = debugElement.nativeElement;
		let input: HTMLInputElement;
		input = fixture.debugElement.query(By.css('#enabled')).nativeElement;
		expect(input.checked.valueOf).toBeTruthy(); // valueOf attribute true indicates checkbox is checked
	});

	it('should have "first_name" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#first_name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	it('should have "window_nt_name" element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#window_nt_name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	it('should have "middle_name element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#middle_name'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	it('should have "phone number element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#phone'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	// karma test for email element task#573716
	it('should have email element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#email'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	// karma test for facilities select box element task#574149 Roles
	it('should have facilities select box element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Facilities'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	// karma test for Roles select box element task#573868
	it('should have Roles multiple select box element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);
	});

	// karma test for Roles select box element task#573868
	it('should have available Role OF "FEE SUPERVISOR"', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement.attributes.getNamedItem('FEE SUPERVISOR')).toBeDefined();

	});

	// karma test for Roles select box element task#573868
	it('should have available Role OF "FEE VISN PGM MANAGER"', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement.attributes.getNamedItem('FEE SUPERVISOR VISN PGM MANAGER')).toBeDefined();

	});

	// karma test for Roles select box element task#573868
	it('should have available Role OF "FPPS ADMIN"', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement.attributes.getNamedItem('FPPS ADMIN')).toBeDefined();

	});

	// karma test for Roles select box element task#573868
	it('should have available Role OF "FPPS HELP DESK"', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#Roles'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement.attributes.getNamedItem('FPPS HELP DESK')).toBeDefined();

	});

	// First Part karma test for Submit button element task#
	it('should have Submit button element', () => {
		const debugElement: DebugElement = fixture.debugElement.query(By.css('#submit'));
		const htmlElement: HTMLElement = debugElement.nativeElement;

		expect(htmlElement).toBeTruthy();
		expect(htmlElement.hidden).toEqual(false);
		expect(htmlElement.hidden).toBe(false);

	});

	// Second Part karma test for Submit button element task#
	it('should have Submit button element disabled', () => {
		const subBtn = fixture.debugElement.query(By.css('#submit')).nativeElement;
		fixture.whenStable().then(() => {
			expect(subBtn.disabled).toBe(true);
		});

	});

});
