import { Component, OnInit } from '@angular/core';
import { AuthenticationService } from '../../login/service/login.service';
import { AuthenticationParams } from '../../shared/models/AuthenticationParams';
import { AuthenticationResponse } from '../../shared/models/AuthenticationResponse';
import { UserInfo } from '../../shared/models/UserInfo';
import { Router } from '@angular/router';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Location } from '@angular/common';

@Component({
  selector: 'app-fpps-login',
  templateUrl: './fpps-login.component.html',
  styleUrls: ['./fpps-login.component.scss']
})
export class FppsLoginComponent implements OnInit {
  public authenticationParams: AuthenticationParams;
  public userInfo: UserInfo;
  public usrInfo: UserInfo;
  public getParam = new URLSearchParams();
  public headers = new Headers();
  public authenticationResponse: AuthenticationResponse = new AuthenticationResponse('1000');
  public userId: any;


  public selectedRole: string;
  constructor(private authenticationService: AuthenticationService, private router: Router, private location: Location) { }
  ngOnInit() {
    this.authenticationService.getAuthenticationParams().subscribe(
      data => this.authenticationParams = data,
      error => alert(error),
      () => (
        console.log('AuthenticationParams are :' + JSON.stringify(this.authenticationParams))
      )
    );
  }


  authenticate() {
    // Sending the parameters
    this.getUserRoles();

  }

  getUserRoles() {
    // Need to set the guid and caputuredUrl
    // console.log('Data to the node is :' + JSON.stringify(this.authenticationResponse)),
    // 	console.log('userId from the authentication server is :' + this.userId);
    // this.getParam.set("guid",this.userId);
    this.getParam = new URLSearchParams();
    this.headers.append('Content-Type', 'application/json');
    const options = new RequestOptions({ headers: this.headers, body: this.authenticationResponse });

    this.authenticationService.authenticateAndGetRoles(options).subscribe(
      data => this.usrInfo = data,
      error => alert(error),
      () => (
        this.userInfo = this.usrInfo,
        this.redirect()
      )
    );
  }

  redirect() {
    // console.log("Number of Roles assigned to the user :"+this.userInfo.userRoles.length);
    // console.log("UserName is :"+JSON.stringify(this.userInfo));
    if (this.userInfo.userRoles !== undefined) {
      // console.log(' Response from the backend is :' + JSON.stringify(this.userInfo));
      this.router.navigate(['home']);
      sessionStorage.setItem('role', this.userInfo.userRoles.length.toString());
      sessionStorage.setItem('userName', this.userInfo.userName);
      sessionStorage.setItem('lastLogin', this.userInfo.lastLogin);
      sessionStorage.setItem('userRole', JSON.stringify(this.userInfo.userRoles));
      sessionStorage.setItem('userInfo', JSON.stringify(this.userInfo));
      sessionStorage.setItem("visns", this.userInfo.userFacilityData.visns);
      sessionStorage.setItem("privacyRestrictions", this.userInfo.userFacilityData.privacyRestrictions);
    } else {
      this.router.navigate(['loginError']);
    }
  }

  decline() {
    sessionStorage.clear();
    this.location.replaceState('/');
    this.router.navigate(['loginError']);
  }
}
