import { Component, OnInit } from '@angular/core';
// importing form things....
import { FormBuilder, FormGroup, Validators } from '@angular/forms';

@Component({
  selector: 'app-form-test',
  templateUrl: './form-test.component.html',
  styleUrls: ['./form-test.component.scss']
})
export class FormTestComponent implements OnInit {
  // form instance to be created.
  form: FormGroup;
  dropDownInitialValue = 'Initial Selection';
  // this regex will check to make sure only letters are being entered.
  stringOnlyValidation = /[a-zA-Z]*/g;

  // reactive form method is being implemented so karma unit testing can be performed
  constructor(private formBuilder: FormBuilder) {
    // this method initializes the form before the componented is mounted.
    this.formInit();
  }

  ngOnInit() {}

  // Method that sets up the form
  formInit() {
    this.form = this.formBuilder.group({
      textInput1: ['', Validators.pattern(this.stringOnlyValidation)],
      textInput2: ['', Validators.required],
      textInput3: '',
      dropDown1: this.dropDownInitialValue,
      dropDown2: [this.dropDownInitialValue],
      dropDown3: this.dropDownInitialValue,
      radioButton: '',
      // checkBoxValues: this.formBuilder.array([false, false, false]),

      tabInput1: ['', Validators.pattern(this.stringOnlyValidation)],
      tabInput2: ['', Validators.pattern(this.stringOnlyValidation)],
      tabInput3: ['', Validators.pattern(this.stringOnlyValidation)],
      textArea1: '',
      // you might have to change the '' to option + number;
      multipleSelect1: ''
    });
    this.form.controls['dropDown2'].disable();
  }
}
