import { Observable } from 'rxjs/Observable';
import { FormBuilder } from '@angular/forms';

import { FormTestComponent } from './form-test.component';

describe('FormTestComponent', () => {
  let component: FormTestComponent;
  beforeEach(() => {
    component = new FormTestComponent(new FormBuilder());
  });

  function updateForm() {
    // This function uses the forms controls to set a value to a specific form
    component.form.controls['textInput1'].setValue('Claim');
    component.form.controls['tabInput1'].setValue(2); // This tabInput1 is being set with a value of 2 in order to check validation
    component.form.controls['tabInput2'].setValue('Claim');
    component.form.controls['tabInput3'].setValue('Claim');
  }

  it('FormTestComponent should be created', () => {
    expect(component).toBeTruthy(); // Expects component to be created
  });

  it('should set values on the form using the formControls', () => {
    updateForm(); // We are calling out the updateForm method
    expect(component.form.controls['textInput1'].value).toBe('Claim'); // Expects the value of the form textInput1 to be Claim
    expect(component.form.controls['tabInput1'].status).toBe('INVALID'); // Is having a status check to check if the validation has been triggered and if correct
    expect(component.form.controls['dropDown2'].enabled).toBeFalsy(); // Expects dropDown2 to be disabled since it's disabled in the FormBuilder(component file)
  });
});
