import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Headers, RequestOptions } from '@angular/http';
import { environment } from '../../../environments/environment';
import { RestService } from '../service/rest.service';

@Injectable()
export class TableService {
  constructor(private rest: RestService) { }

  update(url, method, requestBody): Observable<any[]> {
    console.log('Updating with the following url/params: ' + method + ': ' + environment.nodeserver + url + '\n' + JSON.stringify(requestBody));
    if (method === 'GET') {
      return this.rest.getObjectFromUrl<any[]>(
        environment.nodeserver + url,
        new RequestOptions({ headers: new Headers(), body: requestBody })
      );
    } else {
      return this.rest.postObjectFromUrl<any[]>(
        environment.nodeserver + url,
        new RequestOptions({ headers: new Headers(), body: requestBody })
      );
    }
  }
}
