export class SortingFunctions {

  // Franklin Perez: Below function added. From what Franklin can tell problem is that some integer strings
  //   did not have any "/" in them, yet they can parse as a valid Date object.
  public static isValidDate(dateStr): boolean {
    if (typeof dateStr === 'number') {
      return false;
    }

    if (isNaN(Date.parse(dateStr))) {
      return false;
    }

    if (typeof dateStr === 'string' || dateStr instanceof String) {
      let splitArray: string[] = dateStr.split("/");
      if (splitArray.length === 3) {
        return true;
      } else {
        return false;
      }
    }

    return true;
  }

  public static sortBy(id, asc: boolean, items: any[]) {
    const comp = function compare(a, b) {

      // Franklin Perez: Below code is causing sorting of numbers as a string to be sorted incorrectlky.
      //   This was dicovered when doing a Karma Unit Test pertaining to sorting the Reason column.
      //   But now... the Date Colum sorting is not working correctky. Will go ahead and try to fix.

      // if (!isNaN(Date.parse(a[id])) && !isNaN(Date.parse(b[id]))) { // Franklin Perez: This line was here originally!
      if (SortingFunctions.isValidDate(a[id]) && SortingFunctions.isValidDate(b[id])) {
        a = Date.parse(a[id]);
        b = Date.parse(b[id]);
        return (asc ? -1 : 1) * (a - b);
      }

      if (a[id] < b[id]) {
        return (asc ? -1 : 1) * -1;
      }
      if (a[id] > b[id]) {
        return (asc ? -1 : 1) * 1;

      }
      return 0;
    }

    items.sort(comp);

    // Franklin Perez: Debug Code
		/*
		items.forEach(item => {
				console.log("SortFunction item.reason = " + item.reason);
			}
		);
		*/

    return items;
  }
  constructor() { }

}
