import { Component, Input, Output, EventEmitter } from '@angular/core';

@Component({
  selector: 'pagination-component',
  templateUrl: './pagination.component.html',
  styleUrls: ['./pagination.component.scss']
})
export class PaginationComponent {
  @Input() pageNum = 0;
  @Input() numPages = 0;
  @Output() notify: EventEmitter<number> = new EventEmitter<number>();

  constructor() { }

  // navigates to the page (0-n)
  // top page is equal to numPages-1. Follows array index number scheme
  page(i: number) {
    // if a valid page number, else go to either first or last page
    if (i >= 0 && i < this.numPages)
      this.pageNum = i;
    else if (i < 0)
      this.pageNum = 0;
    else
      this.pageNum = this.numPages - 1;
    this.notify.emit(this.pageNum);
  }
}
