import { Injectable } from '@angular/core';
import 'rxjs/add/operator/map';
import { Observable } from 'rxjs/Observable';
import { RequestOptions, URLSearchParams, Headers, Response, Http } from '@angular/http';

@Injectable()
export class RestService {
	constructor(private http: Http) { }

	public postObjectFromUrl<T>(url: string, requestBody?): Observable<T> {
		return this.http.post(url, requestBody).map((res: Response) => <T>res.json());
	}
	public getObjectFromUrl<T>(url: string, requestBody?): Observable<T> {
		return this.http.get(url, requestBody).map((res: Response) => <T>res.json());
	}
	public putObjectFromUrl<T>(url: string, requestBody?): Observable<T> {
		return this.http.put(url, requestBody).map((res: Response) => <T>res.json());
	}
}

