import { Injectable } from '@angular/core';
import { Http, Response } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';

import { environment } from '../../../environments/environment';

@Injectable()
export class RerouteService {
	claims;

	constructor(private http: Http) { }

	// this method gets both history and visn.
	reroute(body) {
		return this.http.post(`${environment.nodeserver}/claims/reroute`, body)
			.map((response: Response) => response.json());
	}

	getFacilities(visn) {
		return this.http.post(`${environment.nodeserver}/claims/reroute/facilities`, visn)
			.map((response: Response) => response.json());
	}

	setClaims(claims) {
		this.claims = claims;

	}

	reroutes(body) {
		return this.http.put(`${environment.nodeserver}/claims/reroute/reroutes`, body)
			.map((response: Response) => response.json());
	}

	getClaims(): Observable<any[]> {
		return new Observable(observer => observer.next(this.claims));
	}
}
