import { Component, Input, OnInit } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Observable } from 'rxjs/Rx';
import { Headers, RequestOptions } from '@angular/http';
import { RerouteService } from './reroute.service';

@Component({
  selector: 'app-reroute',
  templateUrl: './reroute.component.html',
  styleUrls: ['./reroute.component.scss']
})
export class RerouteComponent implements OnInit {
  karmaUnitTesingBeingDone = false;
  claimsTobeRouted = [];
  rerouteClaimIds = [];
  claimsRerouteHistory;
  selectedVisns;
  selectedVisn = '';
  selectedFacilities = [];
  selectedFacility = '';
  selectedReason = '';
  selectedComments = '';
  historyClaimId = [];
  historyClaimIds = [];
  claimsThatCanBeRerouted = [];
  nonRouted = '';
  btnRerouteClicked = false;
  reroutedSuccessful = '';
  errorCodeAndDescription;
  deniedReroutes;
  errorMessages;

  constructor(private rerouteService: RerouteService) {}

  ngOnInit() {
    if (!this.karmaUnitTesingBeingDone) {
      this.rerouteService.getClaims().subscribe(data => {
        // console.log("RerouteComponent.ngOnInit : getClaims() data = " + JSON.stringify(data));

        this.claimsTobeRouted = data;
        // console.log("RerouteComponent.ngOnInit : this.claimsTobeRouted = " + JSON.stringify(this.claimsTobeRouted));

        this.rerouteClaimIds = this.claimsTobeRouted.map(
          claim => +claim.claimId
        );
        // console.log("RerouteComponent.ngOnInit : this.rerouteClaimIds = " + JSON.stringify(this.rerouteClaimIds));

        this.rerouteService.reroute(this.rerouteClaimIds).subscribe(data => {
          // console.log("RerouteComponent.ngOnInit : reroute() data = " + JSON.stringify(data));

          this.selectedVisns = data.visns;
          // console.log("RerouteComponent.ngOnInit : reroute() data.visns = " + JSON.stringify(data.visns));
          // console.log("RerouteComponent.ngOnInit : this.selectedVisns = " + JSON.stringify(this.selectedVisns));

          // console.log("RerouteComponent.ngOnInit : reroute() data.claims_to_be_rerouted = " + JSON.stringify(data.claims_to_be_rerouted));

          this.claimsRerouteHistory = data.reroute_history;
          // console.log("RerouteComponent.ngOnInit : reroute() data.reroute_history = " + JSON.stringify(data.reroute_history));
          // console.log("RerouteComponent.ngOnInit : this.claimsRerouteHistory = " + JSON.stringify(this.claimsRerouteHistory));

          this.historyClaimIds = [];
          this.claimsThatCanBeRerouted = [];
          if (data.claims_to_be_rerouted) {
            this.historyClaimIds = data.claims_to_be_rerouted.map(
              claim => claim.claim_id
            );

            // The claims that trully can be re-routed, along with their appropriate information, will show up in "data.claims_to_be_rerouted".
            this.claimsThatCanBeRerouted = data.claims_to_be_rerouted;
          }

          // The are claims that cannot be routed.
          this.nonRouted = '';
          if (data.nonRouted && data.nonRouted.length > 0) {
            this.nonRouted = data.nonRouted;
          }

          // console.log("RerouteComponent.ngOnInit : this.historyClaimIds = " + JSON.stringify(this.historyClaimIds));
          // console.log("RerouteComponent.ngOnInit : this.claimsThatCanBeRerouted = " + JSON.stringify(this.claimsThatCanBeRerouted));
          // console.log("RerouteComponent.ngOnInit : this.nonRouted = " + JSON.stringify(this.nonRouted));
        });
      });
    } // end of if statement
  }

  onSelectVisn(selectedVisn) {
    this.selectedVisn = selectedVisn;
    const facility = {
      selectedVisn: this.selectedVisn
    };

    this.rerouteService.getFacilities(facility).subscribe(data => {
      if (data.facilities) {
        this.selectedFacilities = data.facilities;
      }
    });
  }

  onSubmit(f: NgForm) {
    // console.log("Inside of RerouteComponent.onSubmit!");
    // console.log("   this.selectedVisn = " + this.selectedVisn);
    // console.log("   f.value.visnSelect = " + f.value.visnSelect);
    // console.log("   this.selectedFacility = " + this.selectedFacility);
    // console.log("   this.selectedReason = " + this.selectedReason);
    // console.log("   this.selectedComments = " + this.selectedComments);

    this.btnRerouteClicked = true;

    const body = {
      claims_to_be_rerouted: this.claimsThatCanBeRerouted,
      selectedVisn: this.selectedVisn,
      selectedFacility: this.selectedFacility,
      selectedReason: this.selectedReason,
      comment: this.selectedComments,
      current_user_name: sessionStorage.getItem('userName')
    };

    // console.log("   request body = " + JSON.stringify(body));

    this.reroutedSuccessful = '';
    this.errorCodeAndDescription = null;
    this.deniedReroutes = [];
    this.errorMessages = [];
    this.rerouteService.reroutes(body).subscribe(data => {
      // console.log("   response data = " + JSON.stringify(data));
      // console.log("   response data = " + data);

      // Debug Code.
      // data.reroutedSuccessful = null;

      this.reroutedSuccessful = '';
      if (data.reroutedSuccessful) {
        this.reroutedSuccessful = data.reroutedSuccessful;
      }

      // Debug Code.
      // data.error_code = "Claim(s) not rerouted. ";
      // data.error_description = "Invalid VISN: 123";

      this.errorCodeAndDescription = null;
      if (data.error_code) {
        let errorDescription = '';
        if (data.error_description) {
          errorDescription = data.error_description;
        }

        this.errorCodeAndDescription = {
          error_code: data.error_code,
          error_description: errorDescription
        };
      }

      // Debug Code.
      /*
			data.denied_reroutes = [
				{ "claim_id": 2001, "veteran_name": "Benjamin Lewis", "provider_name":"CREW" },
				{ "claim_id": 5000, "veteran_name":" Joey Thai", "provider_name": "FLORIDA" },
				{ "claim_id": 4567, "veteran_name":"Manila Joe", "provider_name": "PHILLIPINES" }
			];
			*/

      this.deniedReroutes = [];
      if (data.denied_reroutes) {
        this.deniedReroutes = data.denied_reroutes;
      }

      // Debug Code.
      /*
			data.errorMessages = [
				"You do not have VISN transfer permission for claim(s):  2001",
				"You are denied Access!",
				"The cat is in the hat!"
			];
			*/

      this.errorMessages = [];
      if (data.errorMessages) {
        this.errorMessages = data.errorMessages;
      }
    });
  }
}
