import { Injectable } from "@angular/core";
import "rxjs/add/operator/map";
import { Observable } from "rxjs/Observable";
import {
  RequestOptions,
  URLSearchParams,
  Headers,
  Response,
  Http
} from "@angular/http";

import { environment } from "../../../../environments/environment";

@Injectable()
export class RejectClaimsService {
  constructor(private http: Http) {}

  public getRejectClaims(requestBody) {
    console.log("sending request to the node for claims");
    return this.http
      .post(environment.nodeserver + "/rejectClaims", requestBody)
      .map((res: Response) => res.json());
    // .catch((error: Response) => Observable.throw(error.json));
  }

  /*
  public okDisapprove(requestBody) {
    console.log("sending request to the node for claims");
    return this.http
      .post(environment.nodeserver + "/okdisapproval", requestBody)
      .map((res: Response) => res.json());
    // .catch((error: Response) => Observable.throw(error.json));
  }
  */

  public reverseDisapprove(requestBody) {
    console.log("sending request to the node for Reverse Disapproval of Claims");
    return this.http
      .post(environment.nodeserver + "/reverseDisapproval", requestBody)
      .map((res: Response) => res.json());
    // .catch((error: Response) => Observable.throw(error.json));
  }
}
