import { Injectable } from "@angular/core";
import "rxjs/add/operator/map";
import { Observable } from "rxjs/Observable";
import {
  RequestOptions,
  URLSearchParams,
  Headers,
  Response,
  Http
} from "@angular/http";
import { environment } from "../../../../environments/environment";

@Injectable()
export class OkDisapprovalService {
  toBeDisapproved: any[] = [];
  constructor(private http: Http) {}
  username = sessionStorage.getItem("userName");
  public okDisapproval(requestBody) {
    console.log("sending request to the node for ok disapproval");
    return this.http
      .post(environment.nodeserver + "/okDisapproval", requestBody)
      .map((res: Response) => res.json());
    // .catch((error: Response) => Observable.throw(error.json));
  }

  public executeRestForUrl(
    url: string,
    requestOptions: RequestOptions
  ): Observable<any[]> {
    const responseData = this.http
      .get(url, requestOptions)
      .map((res: Response) => <any[]>res.json());
    return responseData;
  }
}
