import { Component, Input, OnInit, ViewChild, OnDestroy } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';

import { OkDisapprovalService } from './service/ok-disapproval.sevice';
import { RejectClaimsService } from './service/reject-claim.service';
import { ModalComponent } from './../../shared/modal/modal.component';
import { Comment } from './reject-claim.model';
import { ClaimHistory } from './reject-claim-history.model';

@Component({
  selector: 'app-reject-claim',
  templateUrl: './reject-claim.component.html',
  styleUrls: ['./reject-claim.component.scss']
})
export class RejectClaimComponent implements OnInit, OnDestroy {
  @Input() claimsData: any[] = [];
  @ViewChild('f') form: ModalComponent;
  @ViewChild('modal') modal: ModalComponent;
  modalTitle = 'Enter Comments for Claim';

  // This is for when the OK Disapproval button is clicked.
  btnClicked: boolean;

  // This is for when the Reverse Disapproval button is clicked.
  reverseDisapprovalBtnClicked: boolean;

  karmaUnitTestConfirmationMessage: boolean = true;

  // toggle modal visibility
  hidden = true;
  failedClaims: number[] = [];
  fetchingData = true;
  reverseDisapprovedFailedClaims: number[] = [];
  disapprovedClaims: number[] = [];
  reverseDisapprovedClaims: number[] = [];
  claimstoDisapprove: number[] = [];
  claimsToReverseDisapproval: number[] = [];
  username = sessionStorage.getItem('userName');
  selectedCommentId = null;
  currentComment: string;
  input: Comment[] = [];
  tempComments: Comment[] = [];
  showHistory = false;
  currentClaimID: number;
  selectedClaimHistories: any[];
  historyTableHeader = ['Date', 'Rejected By', 'Reason', 'Explanation', 'Reviewed By', 'Outcome', 'Reviewer Comments'];
  public cols: any[] = [
    { name: 'Select?', id: 'selected', selectBox: true },
    { name: 'Claim ID', id: 'claimId', number: true },
    { name: 'Claim Type', id: 'claimType' },
    { name: 'HERO', id: 'hero' },
    { name: 'Patient ID', id: 'patientId' },
    { name: 'Claim Date', id: 'claimDate', number: true },
    { name: 'Claim Amt.', id: 'claimAmount', currency: true },
    { name: 'Provider', id: 'providerName' },
    { name: 'Disapproved By', id: 'disapprovedBy' },
    { name: 'Disapproved', id: 'disapprovedDate', number: true },
    { name: 'Reason', id: 'reason', number: true },
    { name: 'Explanation', id: 'explanation' },
    {
      name: 'Comments',
      id: 'comments',
      image: 'ic_comment_black_24px.svg',
      sort: false
    },

    {
      name: 'History',
      id: 'history',
      image: 'ic_history_black_24px.svg',
      sort: false
    }
  ];

  headers = new Headers();
  karmaUnitTesingBeingDone = false;

  constructor(
    private rejectClaimsService: RejectClaimsService,
    private disapproveService: OkDisapprovalService
  ) { }

  ngOnInit() {
    this.btnClicked = false;
    this.reverseDisapprovalBtnClicked = false;
    const userRoles: any[] = <any>JSON.parse(
      sessionStorage.getItem('userRole')
    );
    const privacyRestrictions = [];
    userRoles.forEach(userRole => {
      privacyRestrictions.push(userRole.roleName);

    });

    if (!this.karmaUnitTesingBeingDone) {
      const requestOptions = new RequestOptions({
        headers: this.headers,
        body: {
          activeStations: sessionStorage.getItem('activeStations').split(', '),
          privacyRestrictions: sessionStorage.getItem('privacyRestrictions').split(',')
          // Also need to add the visns to the request 
          // visns: sessionStorage.getItem('visns').split(','),
        }
      });
      let rejectedClaims: any[] = [];
      const rejectedClaimsMap = new Map<number, any>();

      this.rejectClaimsService.getRejectClaims(requestOptions).subscribe(
        data => {
          rejectedClaims = JSON.parse(JSON.stringify(data));
          rejectedClaims.forEach(rejectedClaim => {

            rejectedClaimsMap.set(rejectedClaim.claimId, rejectedClaim);
          });

          rejectedClaimsMap.forEach(rejectedClaimFromMap => {

            const rejectedClaim = {
              claimId: rejectedClaimFromMap.claimId,
              claimStatus: rejectedClaimFromMap.claimStatus,
              claimType: rejectedClaimFromMap.claimType,
              hero: rejectedClaimFromMap.hero,
              claimDate: rejectedClaimFromMap.claimDate,
              patientId: rejectedClaimFromMap.ssn,
              claimAmount: rejectedClaimFromMap.claimAmount,
              providerName: rejectedClaimFromMap.providerName,
              disapprovedBy: rejectedClaimFromMap.disapprovedBy,
              disapprovedDate: rejectedClaimFromMap.disapprovedDate,
              reason: rejectedClaimFromMap.reason,
              explanation: rejectedClaimFromMap.reasonDesc,
              rejectionHist: rejectedClaimFromMap.rejectionHist

            };

            this.claimsData.push(rejectedClaim);
            this.claimsData.forEach(claim => { claim.claimIdLink = '/claimDetail/' + claim.claimId; });
          });
          this.fetchingData = false;
        },
        error => alert(error)
      );


      // console.log('Claims Data--------------------------------------'+ JSON.stringify(this.claimsData));
    }



  }

  // Function that runs when user clicks save
  onSubmit(form: NgForm) {
    const text = form.value.comment;
    const comment: Comment = {
      claimId: this.currentClaimID,
      reviewersComments: text
    };

    const existingComment = this.tempComments.filter(
      comment => comment.claimId === this.currentClaimID
    )[0];
    if (existingComment) {
      existingComment.reviewersComments = text;
    } else {
      this.tempComments.push(comment);
    }

    form.reset();
    this.hidden = true;
  }

  okDisapprovalClicked() {
    this.btnClicked = true;
    const selectedClaims = this.claimsData.filter(claim => claim.selected);
    selectedClaims.forEach(claim => {
      console.log(claim.claimId);
      this.claimstoDisapprove.push(claim.claimId);
      this.input.push(this.getInputById(claim.claimId));
    });



    const options = new RequestOptions({
      headers: this.headers,
      body: this.input,
      params: this.username
    });

    if (!this.karmaUnitTesingBeingDone) {
      this.disapproveService.okDisapproval(options).subscribe(
        data => {
          this.displayConfirmation(data);
        },
        error => alert(error),
        () => console.log('Error')
      );
    } else {
      this.displayConfirmation(this.karmaUnitTestConfirmationMessage);
    }


  }

  reverseDisapprovalClicked() {
    this.reverseDisapprovalBtnClicked = true;
    this.claimsToReverseDisapproval = [];
    this.input = [];

    const selectedClaims = this.claimsData.filter(claim => claim.selected);
    selectedClaims.forEach(claim => {
      this.claimsToReverseDisapproval.push(claim.claimId);
      this.input.push(this.getInputById(claim.claimId));
    });

    const options = new RequestOptions({
      headers: this.headers,
      body: this.input,
      params: this.username
    });

    if (!this.karmaUnitTesingBeingDone) {
      this.rejectClaimsService.reverseDisapprove(options).subscribe(
        data => {
          this.displayReverseDisapprovalConfirmation(data);
        },
        error => alert(error) // ,

      );
    } else {
      this.displayReverseDisapprovalConfirmation(
        this.karmaUnitTestConfirmationMessage
      );
    }
  }

  isNoneChecked(): boolean {
    return this.claimsData.every(_ => !_.selected);
  }

  displayReverseDisapprovalConfirmation(message: boolean) {
    if (message) {
      this.reverseDisapprovedClaims = this.claimsToReverseDisapproval;
    } else {
      this.reverseDisapprovedFailedClaims = this.claimsToReverseDisapproval;
    }
  }

  displayConfirmation(message: boolean) {
    if (message) {
      this.disapprovedClaims = this.claimstoDisapprove;
    } else {
      this.failedClaims = this.claimstoDisapprove;
    }
  }

  // gets refference to which comment was clicked.
  selectedComment(event) {
    this.currentClaimID = event.item.claimId;
    if (event.colId === 'comments') {
      this.hidden = false;
    }
    if (event.colId === 'history') {
      this.getHistory(event.item.claimId);
    }
    this.currentComment = this.getCommentById(this.currentClaimID);
  }
  getCommentById(id) {
    // gets Comments from Claim ID, all the comments are stored in TempComments untill reviewer ok's or reverses disapproval
    if (
      this.tempComments.filter(comment => comment.claimId === id)[0] ===
      undefined
    ) {
      return '';
    } else {
      return this.tempComments.filter(comment => comment.claimId === id)[0]
        .reviewersComments;
    }
  }

  getInputById(id) {
    // gets Input from Claim ID
    if (
      this.tempComments.filter(comment => comment.claimId === id)[0] ==
      undefined
    ) {
      const comment: Comment = { claimId: id, reviewersComments: '' };
      return comment;
    } else {
      return this.tempComments.filter(comment => comment.claimId === id)[0];
    }
  }
  getHistory(claimId) {
    this.currentClaimID = claimId;
    this.selectedClaimHistories = this.claimsData.filter(claim => claim.claimId == this.currentClaimID)[0].rejectionHist;
    this.showHistory = true;

  }

  ngOnDestroy() {
    this.tempComments = [];
  }
}
