// import { async, ComponentFixture, TestBed } from '@angular/core/testing';
// import { RouterTestingModule } from '@angular/router/testing';
// import { FormsModule } from '@angular/forms';
// import { HttpModule } from '@angular/http';
// import { SharedDataService } from '../../shared/service/shared-data.service';
// import { ModalComponent } from '../../shared/modal/modal.component';
// import { PaginationComponent } from '../../shared/table/pagination/pagination.component';
// import { NumPerPageComponent } from '../../shared/table/numPerPage/numPerPage.component';
// import { RejectClaimsService } from './service/reject-claim.service';
// import { OkDisapprovalService } from "./service/ok-disapproval.sevice";
// import { TableService } from '../table/table.service';
// import { RestService } from '../service/rest.service';
// import { RejectClaimComponent } from './reject-claim.component';
// import { MenuComponent } from '../menu/menu.component';
// import { TableComponent } from '../../shared/table/table.component';
// import { DebugElement } from '@angular/core';
// import { By } from '@angular/platform-browser';

// import { SpinnerComponent } from '../../shared/spinner/spinner.component';
// import { WindowRefService } from '../../window-ref.service';
// import { NumResultsComponent } from '../../shared/table/numResults/numResults.component';

// describe('RejectClaimComponent', () => {
//   let component: RejectClaimComponent;
//   let fixture: ComponentFixture<RejectClaimComponent>;

//   beforeEach(async(() => {
//     TestBed.configureTestingModule({
//       imports: [
//         RouterTestingModule.withRoutes([
//           { path: 'login', component: RejectClaimComponent /* faking this for "async" test cases to work */ }
//         ]),
//         FormsModule, HttpModule
//       ],
//       declarations: [RejectClaimComponent, MenuComponent, TableComponent, ModalComponent,
//           PaginationComponent, NumPerPageComponent, NumResultsComponent, SpinnerComponent],
//       providers: [SharedDataService, RejectClaimsService, TableService, RestService,
//           OkDisapprovalService, WindowRefService]
//     })
//       .compileComponents();
//   }));

//   beforeEach(() => {
//     fixture = TestBed.createComponent(RejectClaimComponent);
//     component = fixture.componentInstance;

//     component.karmaUnitTesingBeingDone = true;

//     const userRoles: any[] = [
//       { 'roleName': 'FEE_VISN_PGM_MANAGER', 'description': 'Fee Visn Program manager role' },
//       { 'roleName': 'ADMIN', 'description': 'Administrator' },
//       { 'roleName': 'FPPS_HELP_DESK', 'description': 'FPPS HELP DESK Role' },
//       { 'roleName': 'FEE_SUPERVISOR', 'description': 'Fee Supervisor role' },
//       { 'roleName': 'FPPS_ADMIN', 'description': 'ADMIN Role' }
//     ];

//     sessionStorage.setItem('userRole', JSON.stringify(userRoles));

//     fixture.detectChanges();
//   });

//   function setClaimsDataWithOneClaimBeingSelected() {
//     component.claimsData = [
//       {
//         'claimId': 100,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '692',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed',
//         'selected': true
//       },
//       {
//         'claimId': 101,
//         'claimStatus': 'ESTABLISH',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '730869688',
//         'claimDate': '08/05/2017',
//         'claimAmount': 100.32,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'John',
//         'disapprovedDate': '04/09/2017',
//         'reason': '250',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       },
//       {
//         'claimId': 102,
//         'claimStatus': 'COMPLETE',
//         'claimType': 'INST',
//         'hero': 'N',
//         'patientId': '362873227',
//         'claimDate': '05/08/2017',
//         'claimAmount': 1233.23,
//         'providerName': 'PARRISH MED CTR',
//         'disapprovedBy': 'Joseph',
//         'disapprovedDate': '05/10/2017',
//         'reason': '115',
//         'explanation': 'Rejected Claim',
//         // 'comments': 'up to date',
//         // 'history': 'processed'
//       }
//     ];

//     fixture.detectChanges();
//   }

//   function setClaimsDataWithNoClaimBeingSelected() {
//     component.claimsData = [
//       {
//         'claimId': 100,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       },
//       {
//         'claimId': 101,
//         'claimStatus': 'ESTABLISH',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '730869688',
//         'claimDate': '08/05/2017',
//         'claimAmount': 100.32,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'John',
//         'disapprovedDate': '4/09/2017',
//         'reason': '250',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       },
//       {
//         'claimId': 102,
//         'claimStatus': 'COMPLETE',
//         'claimType': 'INST',
//         'hero': 'N',
//         'patientId': '362873227',
//         'claimDate': '05/08/2017',
//         'claimAmount': 1233.23,
//         'providerName': 'PARRISH MED CTR',
//         'disapprovedBy': 'Joseph',
//         'disapprovedDate': '05/10/2017',
//         'reason': '115',
//         'explanation': 'Rejected Claim',
//         // 'comments': 'up to date',
//         // 'history': 'processed'
//       }
//     ];

//     fixture.detectChanges();
//   }

//   function setClaimsDataWithOneHundredTwentyClaimsNoneSelected() {

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//     }

//     fixture.detectChanges();
//   }

//   function getRandomNumberString(aLength: number): string {
//       var text = "";
//       var possible = "0123456789";

//       for (var i = 0; i < aLength; i++)
//         text += possible.charAt(Math.floor(Math.random() * possible.length));

//       return text;
//   }

//   function getRandomCapitalLettersOnlyString(aLength: number): string {
//       var text = "";
//       var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

//       for (var i = 0; i < aLength; i++)
//         text += possible.charAt(Math.floor(Math.random() * possible.length));

//       return text;
//   }

//   function getRandomHeroString(): string {
//       var text = "";
//       var possible = "NY";

//       for (var i = 0; i < 1; i++)
//         text += possible.charAt(Math.floor(Math.random() * possible.length));

//       return text;
//   }

//   function getRandomDate(): string {
//       let startDate = new Date(1930, 0, 1);
//       let todayDate = new Date();
//       let randomDate = new Date(startDate.getTime() + Math.random() * (todayDate.getTime() - startDate.getTime()));

//       let randomMonth = randomDate.getMonth() + 1;
//       let randomMonthStr = (randomMonth < 10) ? "0" + randomMonth : randomMonth;
//       let randomDay = randomDate.getDate();
//       let randomDayStr = (randomDay < 10) ? "0" + randomDay : randomDay;
//       let randomYear = randomDate.getFullYear();

//       let randomDateStr = randomMonthStr + "/" + randomDayStr + "/" + randomYear;
//       return randomDateStr;
//   }

//   function getRandomDollarAmount(): number {
//       let largestNumber: number = 9999.99;
//       let smallestNumber: number = 0.00;
//       let randomNumberStr = (Math.random() * (largestNumber - smallestNumber) + smallestNumber).toFixed(2);
//       let randomDollarAmount: number = +randomNumberStr;

//       return randomDollarAmount;
//   }

//   function formatNumbertoCommaSeperated(nStr): string {
//     nStr += '';
//     var x = nStr.split('.');
//     var x1 = x[0];
//     var x2 = x.length > 1 ? '.' + x[1] : '';
//     var rgx = /(\d+)(\d{3})/;
//     while (rgx.test(x1)) {
//       x1 = x1.replace(rgx, '$1' + ',' + '$2');
//     }
//     return x1 + x2;
//   }

//   it('should be created', () => {
//     expect(component).toBeTruthy();
//   });

//   it('should have "table" element exist when no claims data exists', () => {
//     let debugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let htmlElement: HTMLElement = debugElement.nativeElement;
//     expect(htmlElement).toBeTruthy();

//     debugElement = fixture.debugElement.query(By.css('table-component'));
//     htmlElement = debugElement.nativeElement;
//     expect(htmlElement).toBeTruthy();

//     expect(htmlElement.getAttribute("id")).toEqual("table");
//   });

//   it('should have "table" element exist when claims data exists', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let debugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let htmlElement: HTMLElement = debugElement.nativeElement;
//     expect(htmlElement).toBeTruthy();

//     debugElement = fixture.debugElement.query(By.css('table-component'));
//     htmlElement = debugElement.nativeElement;
//     expect(htmlElement).toBeTruthy();

//     expect(htmlElement.getAttribute("id")).toEqual("table");
//   });

//   it('should have "upper ok disapproval" button exist', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy()
//   });

//   it('should have "upper ok disapproval" button be visible', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.hidden).toEqual(false);
//     expect(htmlElement.hidden).toBe(false);
//   });

//   it('should have "upper ok disapproval" button be disabled when no data exists in the table', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "upper ok disapproval" button be disabled when data exists in the table and no claim is selected', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "upper ok disapproval" button be enabled when data exists in the table and one (or more) claims are selected', () => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).toBeNull();
//   });

//   it('should not call "okDisapprovalClicked" method when "upper ok disapproval" button is clicked when disabled', async(() => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should not call "okDisapprovalClicked" method when "upper ok disapproval" button is clicked and data exists in table but none are selected', async(() => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should call "okDisapprovalClicked" method when "upper ok disapproval" button is clicked and data exists in table with one (or more) claims selected', async(() => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).toHaveBeenCalled();
//     });
//   }));

//   it('when "upper ok disapproval" button is clicked and one (or more) claims are selected, a Successful Disapproval Message should display if a successful Disapproval of claims is done', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the successful disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = true;

//     // Click on the Upper OK Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let successfulClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#successfulClaimsDisapprovalMessage'));
//     let successfulClaimsDisapprovalMessageHtmlElement: HTMLElement = successfulClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(successfulClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Accepted disapproval of Claim(s): 100, 101, 102";
//     expect(successfulClaimsDisapprovalMessageHtmlElement.innerText).toEqual(expectedMessage);
//   });

//   it('when "upper ok disapproval" button is clicked and one (or more) claims are selected, a Failed Disapproval Message should display if a Disapproval of claims are unsuccessful', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the unsuccessful disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = false;

//     // Click on the Upper OK Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#upperOkDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let failedClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#failedClaimsDisapprovalMessage'));
//     let failedClaimsDisapprovalMessageHtmlElement: HTMLElement = failedClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(failedClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Error while disapproving the following claim(s):";
//     expect(failedClaimsDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//     expectedMessage = "100, 101, 102";
//     expect(failedClaimsDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//   });

//   it('should have "lower ok disapproval" button exist', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy()
//   });

//   it('should have "lower ok disapproval" button be visible', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.hidden).toEqual(false);
//     expect(htmlElement.hidden).toBe(false);
//   });

//   it('should have "lower ok disapproval" button be disabled when no data exists in the table', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "lower ok disapproval" button be disabled when data exists in the table and no claim is selected', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "lower ok disapproval" button be enabled when data exists in the table and one (or more) claims are selected', () => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).toBeNull();
//   });

//   it('should not call "okDisapprovalClicked" method when "lower ok disapproval" button is clicked when disabled', async(() => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should not call "okDisapprovalClicked" method when "lower ok disapproval" button is clicked and data exists in table but none are selected', async(() => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should call "okDisapprovalClicked" method when "lower ok disapproval" button is clicked and data exists in table with one (or more) claims selected', async(() => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'okDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.okDisapprovalClicked).toHaveBeenCalled();
//     });
//   }));

//   it('when "lower ok disapproval" button is clicked and one (or more) claims are selected, a Successful Disapproval Message should display if a successful Disapproval of claims is done', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the successful disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = true;

//     // Click on the Lower OK Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let successfulClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#successfulClaimsDisapprovalMessage'));
//     let successfulClaimsDisapprovalMessageHtmlElement: HTMLElement = successfulClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(successfulClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Accepted disapproval of Claim(s): 100, 101, 102";
//     expect(successfulClaimsDisapprovalMessageHtmlElement.innerText).toEqual(expectedMessage);
//   });

//   it('when "lower ok disapproval" button is clicked and one (or more) claims are selected, a Failed Disapproval Message should display if a Disapproval of claims are unsuccessful', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the unsuccessful disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = false;

//     // Click on the Lower OK Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#lowerOkDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let failedClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#failedClaimsDisapprovalMessage'));
//     let failedClaimsDisapprovalMessageHtmlElement: HTMLElement = failedClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(failedClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Error while disapproving the following claim(s):";
//     expect(failedClaimsDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//     expectedMessage = "100, 101, 102";
//     expect(failedClaimsDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//   });

//   it('should have "upper reverse disapproval" button exist', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy()
//   });

//   it('should have "upper reverse disapproval" button be visible', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.hidden).toEqual(false);
//     expect(htmlElement.hidden).toBe(false);
//   });

//   it('should have "upper reverse disapproval" button be disabled when no data exists in the table', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "upper reverse disapproval" button be disabled when data exists in the table and no claim is selected', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   // tslint:disable-next-line:max-line-length
//   it('should have "upper reverse disapproval" button be enabled when data exists in the table and one (or more) claims are selected', () => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).toBeNull();
//   });

//   it('should not call "reverseDisapprovalClicked" method when "upper reverse disapproval" button is clicked when disabled', async(() => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should not call "reverseDisapprovalClicked" method when "upper reverse disapproval" button is clicked and data exists in table but none are selected', async(() => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should call "reverseDisapprovalClicked" method when "upper reverse disapproval" button is clicked and data exists in table with one (or more) claims selected', async(() => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).toHaveBeenCalled();
//     });
//   }));

//   it('when "upper reverse disapproval" button is clicked and one (or more) claims are selected, a Successful Reverse Disapproval Message should display if a successful Reverse Disapproval of claims is done', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the successful reverse disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = true;

//     // Click on the Upper Reverse Disapproval button.
//     let reverseDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     let reverseDisapprovalButtonHtmlElement: HTMLElement = reverseDisapprovalButtonDebugElement.nativeElement;
//     reverseDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let successfulReverseClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#successfulClaimsReverseDisapprovalMessage'));
//     let successfulReverseClaimsDisapprovalMessageHtmlElement: HTMLElement = successfulReverseClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(successfulReverseClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Reversed disapproval of Claim(s): 100, 101, 102";
//     expect(successfulReverseClaimsDisapprovalMessageHtmlElement.innerText).toEqual(expectedMessage);
//   });

//   it('when "upper reverse disapproval" button is clicked and one (or more) claims are selected, a Failed Reverse Disapproval Message should display if a Reverse Disapproval of claims are unsuccessful', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the unsuccessful reverse disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = false;

//     // Click on the Upper Reverse Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#upperReverseDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let failedClaimsReverseDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#failedClaimsReverseDisapprovalMessage'));
//     let failedClaimsReverseDisapprovalMessageHtmlElement: HTMLElement = failedClaimsReverseDisapprovalMessageDebugElement.nativeElement;
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Error while Reverse Disapproving the following claim(s):";
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//     expectedMessage = "100, 101, 102";
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//   });

//   it('should have "lower reverse disapproval" button exist', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy()
//   });

//   it('should have "lower reverse disapproval" button be visible', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.hidden).toEqual(false);
//     expect(htmlElement.hidden).toBe(false);
//   });

//   it('should have "lower reverse disapproval" button be disabled when no data exists in the table', () => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   it('should have "lower reverse disapproval" button be disabled when data exists in the table and no claim is selected', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).not.toBeNull();
//   });

//   // tslint:disable-next-line:max-line-length
//   it('should have "lower reverse disapproval" button be enabled when data exists in the table and one (or more) claims are selected', () => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     expect(htmlElement).toBeTruthy();
//     expect(htmlElement.getAttribute('disabled')).toBeNull();
//   });

//   it('should not call "reverseDisapprovalClicked" method when "lower reverse disapproval" button is clicked when disabled', async(() => {
//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should not call "reverseDisapprovalClicked" method when "lower reverse disapproval" button is clicked and data exists in table but none are selected', async(() => {
//     setClaimsDataWithNoClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).not.toHaveBeenCalled();
//     });
//   }));

//   // tslint:disable-next-line:max-line-length
//   it('should call "reverseDisapprovalClicked" method when "lower reverse disapproval" button is clicked and data exists in table with one (or more) claims selected', async(() => {
//     setClaimsDataWithOneClaimBeingSelected();

//     const debugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     const htmlElement: HTMLElement = debugElement.nativeElement;

//     spyOn(component, 'reverseDisapprovalClicked');

//     htmlElement.click();

//     fixture.whenStable().then(() => {
//       expect(component.reverseDisapprovalClicked).toHaveBeenCalled();
//     });
//   }));

//   it('when "lower reverse disapproval" button is clicked and one (or more) claims are selected, a Successful Reverse Disapproval Message should display if a successful Disapproval of claims is done', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the successful reverse disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = true;

//     // Click on the Lower Reverse Disapproval button.
//     let reverseDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     let reverseDisapprovalButtonHtmlElement: HTMLElement = reverseDisapprovalButtonDebugElement.nativeElement;
//     reverseDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let successfulReverseClaimsDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#successfulClaimsReverseDisapprovalMessage'));
//     let successfulReverseClaimsDisapprovalMessageHtmlElement: HTMLElement = successfulReverseClaimsDisapprovalMessageDebugElement.nativeElement;
//     expect(successfulReverseClaimsDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Reversed disapproval of Claim(s): 100, 101, 102";
//     expect(successfulReverseClaimsDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//   });

//   it('when "lower reverse disapproval" button is clicked and one (or more) claims are selected, a Failed Reverse Disapproval Message should display if a Reverse Disapproval of claims are unsuccessful', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     // Select all Claims in the table.
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     // Mimic the unsuccessful reverse disapproval of the selected claims.
//     component.karmaUnitTestConfirmationMessage = false;

//     // Click on the Lower Reverse Disapproval button.
//     let okDisapprovalButtonDebugElement: DebugElement = fixture.debugElement.query(By.css('#lowerReverseDisapprovalButton'));
//     let okDisapprovalButtonHtmlElement: HTMLElement = okDisapprovalButtonDebugElement.nativeElement;
//     okDisapprovalButtonHtmlElement.click();

//     fixture.detectChanges();

//     // Make sure the correct Confirmation Message element is being displayed.
//     let failedClaimsReverseDisapprovalMessageDebugElement: DebugElement = fixture.debugElement.query(By.css('#failedClaimsReverseDisapprovalMessage'));
//     let failedClaimsReverseDisapprovalMessageHtmlElement: HTMLElement = failedClaimsReverseDisapprovalMessageDebugElement.nativeElement;
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement).toBeTruthy();

//     // Verify that the correct Confirmation Message is displayed.
//     let expectedMessage = "Error while Reverse Disapproving the following claim(s):";
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//     expectedMessage = "100, 101, 102";
//     expect(failedClaimsReverseDisapprovalMessageHtmlElement.innerText).toContain(expectedMessage);
//   });

//   it('verify that clicking on "select" table header column check box causes all the claims in the table to be in the selected state ', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let selectedTableHeaderColumnElement: DebugElement = dataTableElement.query(By.css('#selected'));

//     let selectedCheckBoxDebugElement: DebugElement = selectedTableHeaderColumnElement.query(By.css('[name="colcheckbox"]'));
//     let selectedCheckBoxHtmlElement: HTMLElement = selectedCheckBoxDebugElement.nativeElement;
//     expect(selectedCheckBoxHtmlElement).toBeTruthy();

//     selectedCheckBoxHtmlElement.click();
//     fixture.detectChanges();

//     component.claimsData.forEach(claim => {
//         expect(claim.selected).toEqual(true);
//       }
//     );
//   });

//   it('verify that clicking on all the "select" table row check boxes causes all the claims in the table to be in the selected state', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     selecteRowCheckBoxDebugElements.forEach(selectRowCheckBoxDebugElement => {
//         let selectRowCheckBoxHtmlElement: HTMLElement = selectRowCheckBoxDebugElement.nativeElement;
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     );

//     component.claimsData.forEach(claim => {
//         expect(claim.selected).toEqual(true);
//       }
//     );
//   });

//   it('verify that the table has the correct number of rows based on the number of records of "claimsData"', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     expect(selecteRowCheckBoxDebugElements.length).toEqual(component.claimsData.length);
//   });

//   it('verify that clicking on one of the "select" table row check boxes causes only that one claim to be in the selected state', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     for (let i = 0; i < selecteRowCheckBoxDebugElements.length; i++) {
//       let selectRowCheckBoxHtmlElement: HTMLElement = selecteRowCheckBoxDebugElements[i].nativeElement;
//       if (i === 0) {
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     }

//     for (let i = 0; i < component.claimsData.length; i++) {
//       let claim = component.claimsData[i];
//       if (i === 0) {
//         expect(claim.selected).toEqual(true);
//       } else {
//         expect(claim.selected).toEqual(false || undefined);
//       }
//     }
//   });

//   it('verify that clicking on one but less than all of the "select" table row check boxes causes only those claims that were selected to be in the selected state', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));

//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     for (let i = 0; i < selecteRowCheckBoxDebugElements.length; i++) {
//       let selectRowCheckBoxHtmlElement: HTMLElement = selecteRowCheckBoxDebugElements[i].nativeElement;
//       if ((i === 0) || (i === 2)) {
//         selectRowCheckBoxHtmlElement.click();
//         fixture.detectChanges();
//       }
//     }

//     for (let i = 0; i < component.claimsData.length; i++) {
//       let claim = component.claimsData[i];
//       if ((i === 0) || (i === 2)) {
//         expect(claim.selected).toEqual(true);
//       } else {
//         expect(claim.selected).toEqual(false || undefined);
//       }
//     }
//   });

//   it('verify that the Upper "Number of Results" value is equal to the number of "claimsData" records', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let upperNumberOfResultsDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numResultsTop'));
//     let upperNumberOfResultsHtmlElement: HTMLElement = upperNumberOfResultsDebugElement.nativeElement;

//     expect(upperNumberOfResultsHtmlElement.innerText).toEqual("Number of Results: " + component.claimsData.length);
//   });

//   it('verify that the Lower "Number of Results" value is equal to the number of "claimsData" records', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let lowerNumberOfResultsDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numResultsBottom'));
//     let lowerNumberOfResultsHtmlElement: HTMLElement = lowerNumberOfResultsDebugElement.nativeElement;

//     expect(lowerNumberOfResultsHtmlElement.innerText).toEqual("Number of Results: " + component.claimsData.length);
//   });

//   it('verify that initially the number of viewable Rejected Claims per Page is 10 when 100+ Claims Data present: Upper Page Size Select Element Shows 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTopDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLElement = upperPageSizeSelectDebugElement.nativeElement;

//     expect(upperPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("10");
//   });

//   it('verify that initially the number of viewable Rejected Claims per Page is 10 when 100+ Claims Data present: Lower Page Size Select Element Shows 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLElement = lowerPageSizeSelectDebugElement.nativeElement;

//     expect(lowerPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("10");
//   });

//   it('verify that initially the number of viewable Rejected Claims per Page is 10 when 100+ Claims Data present: Reject Claims Table should have 10 rows', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(10);

//     /*
//     let selecteRowCheckBoxDebugElements: DebugElement[] = dataTableDebugElement.queryAll(By.css('[name="rowcheckbox"]'));
//     expect(selecteRowCheckBoxDebugElements.length).toEqual(10);
//     */
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 25 when 100+ Claims Data present and Upper Page Size Select Element Changed to 25', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTopDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     upperPageSizeSelectHtmlElement.value = "1: 25"; // works
//     // upperPageSizeSelectHtmlElement.value = "25"; // does not work!
//     // upperPageSizeSelectHtmlElement.selectedIndex = 1; // works!
//     // upperPageSizeSelectHtmlElement.setAttribute("ng-reflect-model", "25"); // does not work!
//     upperPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(25);
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 25 when 100+ Claims Data present and Lower Page Size Select Element Changed to 25', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = lowerPageSizeSelectDebugElement.nativeElement;

//     lowerPageSizeSelectHtmlElement.value = "1: 25"; // works
//     lowerPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(25);
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 50 when 100+ Claims Data present and Upper Page Size Select Element Changed to 50', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTopDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     upperPageSizeSelectHtmlElement.value = "2: 50"; // works
//     upperPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(50);
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 50 when 100+ Claims Data present and Lower Page Size Select Element Changed to 50', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = lowerPageSizeSelectDebugElement.nativeElement;

//     lowerPageSizeSelectHtmlElement.value = "2: 50"; // works
//     lowerPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(50);
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 100 when 100+ Claims Data present and Upper Page Size Select Element Changed to 100', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTop: DebugElement = tableComponentDebugElement.query(By.css('#tableComponentDebugElement'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     upperPageSizeSelectHtmlElement.value = "3: 100"; // works
//     upperPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(100);
//   });

//   it('verify that the number of viewable Rejected Claims per Page is 100 when 100+ Claims Data present and Lower Page Size Select Element Changed to 100', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = lowerPageSizeSelectDebugElement.nativeElement;

//     lowerPageSizeSelectHtmlElement.value = "3: 100"; // works
//     lowerPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(100);
//   });

//   // Franklin Perez (9/15/2017): The new Table Component does not have the option to show ALL of the
//   //    data in one page. Thus, will comment the below out and if it's allows in the future will
//   //    bring this Test Case up again.
//   /*
//   it('verify that the number of viewable Rejected Claims per Page is All of the Claims when 100+ Claims Data present and Upper Page Size Select Element Changed to All', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTopDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     upperPageSizeSelectHtmlElement.value = "4: Infinity"; // works
//     upperPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(120);
//   });
//   */

//   // Franklin Perez (9/15/2017): The new Table Component does not have the option to show ALL of the
//   //    data in one page. Thus, will comment the below out and if it's allows in the future will
//   //    bring this Test Case up again.
//   /*
//   it('verify that the number of viewable Rejected Claims per Page is All of the Claims when 100+ Claims Data present and Lower Page Size Select Element Changed to All', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = lowerPageSizeSelectDebugElement.nativeElement;

//     lowerPageSizeSelectHtmlElement.value = "4: Infinity"; // works
//     lowerPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tbodyDebugElement: DebugElement = dataTableDebugElement.query(By.css("tbody"));

//     let trDebugElements: DebugElement[] = tbodyDebugElement.queryAll(By.css("tr"));
//     expect(trDebugElements.length).toEqual(120);
//   });
//   */

//   it('verify that changing the Upper Page Size Select Element Value will also cause the Lower Page Size Select Element Value to be of the same size', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageComponentTopDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     upperPageSizeSelectHtmlElement.value = "1: 25"; // works
//     upperPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     expect(upperPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("25");

//     let lowerPageSizeSelectDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#page-size2'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     expect(lowerPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("25");
//   });

//   it('verify that changing the Lower Page Size Select Element Value will also cause the Upper Page Size Select Element Value to be of the same size', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let numPerPageBottomComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentBottom'));
//     let lowerPageSizeSelectDebugElement: DebugElement = numPerPageBottomComponentDebugElement.query(By.css('#page-size'));
//     let lowerPageSizeSelectHtmlElement: HTMLSelectElement = lowerPageSizeSelectDebugElement.nativeElement;

//     lowerPageSizeSelectHtmlElement.value = "1: 25"; // works
//     lowerPageSizeSelectHtmlElement.dispatchEvent(new Event('change'));

//     fixture.detectChanges();

//     expect(lowerPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("25");

//     let numPerPageTopComponentDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#numPerPageComponentTop'));
//     let upperPageSizeSelectDebugElement: DebugElement = numPerPageTopComponentDebugElement.query(By.css('#page-size'));
//     let upperPageSizeSelectHtmlElement: HTMLSelectElement = upperPageSizeSelectDebugElement.nativeElement;

//     expect(lowerPageSizeSelectHtmlElement.getAttribute("ng-reflect-model")).toEqual("25");
//   });

//   it('verify that the two "paginateFirst" paginate-button elements exist when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let paginateFirstDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateFirst'));
//     expect(paginateFirstDebugElements.length).toEqual(2);

//     paginateFirstDebugElements.forEach(paginateFirstDebugElement => {
//         let paginateFirstHtmlElement: HTMLElement = paginateFirstDebugElement.nativeElement;
//         expect(paginateFirstHtmlElement).toBeTruthy();
//       }
//     );
//   });

//   it('verify that the two "paginateBack" paginate-button elements exist when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateBack'));
//     expect(paginateBackDebugElements.length).toEqual(2);

//     paginateBackDebugElements.forEach(paginateBackDebugElement => {
//         let paginateBackHtmlElement: HTMLElement = paginateBackDebugElement.nativeElement;
//         expect(paginateBackHtmlElement).toBeTruthy();
//       }
//     );
//   });

//   it('verify that the two "pg0" button elements exist and have proper text when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let pg0_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg0'));
//     expect(pg0_DebugElements.length).toEqual(2);

//     pg0_DebugElements.forEach(pg1_DebugElement => {
//         let pg1_HtmlElement: HTMLElement = pg1_DebugElement.nativeElement;
//         expect(pg1_HtmlElement).toBeTruthy();
//         expect(pg1_HtmlElement.innerText).toEqual("1");
//       }
//     );
//   });

//   it('verify that the two "pg0" button elements exist and initially are in the "active" state when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let pg0_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg0'));
//     expect(pg0_DebugElements.length).toEqual(2);

//     pg0_DebugElements.forEach(pg1_DebugElement => {
//         let pg1_HtmlElement: HTMLElement = pg1_DebugElement.nativeElement;
//         expect(pg1_HtmlElement).toBeTruthy();
//         expect(pg1_HtmlElement.getAttribute("class")).toContain("active");
//       }
//     );
//   });

//   it('verify that the two "paginateForward" paginate-button elements exist when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let paginateForwardDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateForward'));
//     expect(paginateForwardDebugElements.length).toEqual(2);

//     paginateForwardDebugElements.forEach(paginateForwardDebugElement => {
//         let paginateForwardHtmlElement: HTMLElement = paginateForwardDebugElement.nativeElement;
//         expect(paginateForwardHtmlElement).toBeTruthy();
//       }
//     );
//   });

//   it('verify that the two "paginateLast" paginate-button elements exist when there are claims to display', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     expect(paginateLastDebugElements.length).toEqual(2);

//     paginateLastDebugElements.forEach(paginateLastDebugElement => {
//         let paginateLastkHtmlElement: HTMLElement = paginateLastDebugElement.nativeElement;
//         expect(paginateLastkHtmlElement).toBeTruthy();
//       }
//     );
//   });

//   it('verify that the two sets of correct "pgX" button elements exist and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//             pgX_DebugElements.forEach(pgX_DebugElement => {
//                 let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//                 expect(pgX_HtmlElement).toBeTruthy();
//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }
//             }
//             );
//         }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "paginateForward" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateForwardDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateForward'));

//     let paginateForwardHtmlElement: HTMLElement = paginateForwardDebugElements[0].nativeElement;
//     paginateForwardHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg1" to "pg4".
//     for (let i = 1; i <= 4; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 4) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 1) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // There should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 10 to 19.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 10; i < 20; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "paginateForward" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateForwardDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateForward'));

//     let paginateForwardHtmlElement: HTMLElement = paginateForwardDebugElements[1].nativeElement;
//     paginateForwardHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg1" to "pg4".
//     for (let i = 1; i <= 4; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 4) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 1) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 10 to 19.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 10; i < 20; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "paginateLast" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));

//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[0].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Debug
//     /*
//     let paginateButtonDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('.paginate-button'));
//     console.log("paginateButtonDebugElements.length = " + paginateButtonDebugElements.length);
//     paginateButtonDebugElements.forEach(paginateButtonDebugElement => {
//         let paginateButtonHtmllement: HTMLElement = paginateButtonDebugElement.nativeElement;
//         console.log("  paginateButtonHtmllement.getAttribute('id') = " + paginateButtonHtmllement.getAttribute("id"));
//       }
//     );
//     */

//     // There should be 4 "pgX" button elements as follows: pg8, pg9, pg10, pg11
//     for (let i = 8; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 8) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 11) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 110; i < 120; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "paginateLast" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));

//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[1].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements as follows: pg8, pg9, pg10, pg11
//     for (let i = 8; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 8) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 11) {
//              expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 110; i < 120; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that no changes exist when the top "paginateFirst" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateFirstDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateFirst'));

//     let paginateFirstHtmlElement: HTMLElement = paginateFirstDebugElements[0].nativeElement;
//     paginateFirstHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that no changes exist when the bottom "paginateFirst" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateFirstDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateFirst'));

//     let paginateFirstHtmlElement: HTMLElement = paginateFirstDebugElements[1].nativeElement;
//     paginateFirstHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that no changes exist when the top "paginateBack" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateBack'));

//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[0].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that no changes exist when the bottom "paginateBack" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateBack'));

//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[1].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "pg2" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginatePg2_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg2'));

//     let paginatePg2_HtmlElement: HTMLElement = paginatePg2_DebugElements[0].nativeElement;
//     paginatePg2_HtmlElement.click();
//     fixture.detectChanges();

//     // There should be 6 "pgX" button elements as follows: pg0, pg1, pg2, pg3, pg4, pg5
//     for (let i = 0; i <= 5; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 5) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 2) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 20 to 29.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 20; i < 30; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "pg2" paginate-button is clicked and have proper text when there are 120 claims to display and an inital page size of 10', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let paginatePg2_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg2'));

//     let paginatePg2_HtmlElement: HTMLElement = paginatePg2_DebugElements[1].nativeElement;
//     paginatePg2_HtmlElement.click();
//     fixture.detectChanges();

//     // There should be 6 "pgX" button elements as follows: pg0, pg1, pg2, pg3, pg4, pg5
//     for (let i = 0; i <= 5; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 5) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 2) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 20 to 29.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 20; i < 30; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "paginateFirst" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[0].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "paginateFirst" paginate-button to go to the first page.
//     let paginateFirstDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateFirst'));
//     let paginateFirstHtmlElement: HTMLElement = paginateFirstDebugElements[0].nativeElement;
//     paginateFirstHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // There should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "paginateFirst" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[1].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "paginateFirst" paginate-button to go to the first page.
//     let paginateFirstDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateFirst'));
//     let paginateFirstHtmlElement: HTMLElement = paginateFirstDebugElements[1].nativeElement;
//     paginateFirstHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 4 "pgX" button elements going from "pg0" to "pg3".
//     for (let i = 0; i <= 3; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 3) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 0) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 0 to 9.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "paginateBack" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[0].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "paginateBack" paginate-button to go to the first page.
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateBack'));
//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[0].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 5 "pgX" button elements as follows: pg7, pg8, pg9, pg10, pg11
//     for (let i = 7; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 7) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 10) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 100 to 109.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 100; i < 110; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "paginateBack" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[1].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "paginateBack" paginate-button to go to the first page.
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateBack'));
//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[1].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 5 "pgX" button elements as follows: pg7, pg8, pg9, pg10, pg11
//     for (let i = 7; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 7) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 10) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 100 to 109.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 100; i < 110; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the top "pg10" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[0].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "pg10" paginate-button to go to the first page.
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg10'));
//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[0].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 5 "pgX" button elements as follows: pg7, pg8, pg9, pg10, pg11
//     for (let i = 7; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 7) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 10) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 100 to 109.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 100; i < 110; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that the two sets of correct "pgX" button elements exist when the bottom "pg10" paginate-button is clicked and have proper text when there are 120 claims to display, an inital page size of 10, and last page is being displayed', () => {
//     setClaimsDataWithOneHundredTwentyClaimsNoneSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));

//     // Click first on the top "paginateLast" paginate-button to go to the last page.
//     let paginateLastDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#paginateLast'));
//     let paginateLastHtmlElement: HTMLElement = paginateLastDebugElements[1].nativeElement;
//     paginateLastHtmlElement.click();
//     fixture.detectChanges();

//     // Then, click on the "pg10" paginate-button to go to the first page.
//     let paginateBackDebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg10'));
//     let paginateBackHtmlElement: HTMLElement = paginateBackDebugElements[1].nativeElement;
//     paginateBackHtmlElement.click();
//     fixture.detectChanges();

//     // There should be 5 "pgX" button elements as follows: pg7, pg8, pg9, pg10, pg11
//     for (let i = 7; i <= 11; i++) {
//       let pgX_DebugElements: DebugElement[] = tableComponentDebugElement.queryAll(By.css('#pg' + i));
//       expect(pgX_DebugElements.length).toEqual(2);

//       pgX_DebugElements.forEach(pgX_DebugElement => {
//           let pgX_HtmlElement: HTMLElement = pgX_DebugElement.nativeElement;
//           expect(pgX_HtmlElement).toBeTruthy();

//                 if (i === 7) {
//                     expect(pgX_HtmlElement.innerText).toEqual("...");
//                 } else {
//                     expect(pgX_HtmlElement.innerText).toEqual("" + (i + 1));
//                 }

//           if (i === 10) {
//               expect(pgX_HtmlElement.getAttribute("class")).toContain("active");
//           } else {
//               expect(pgX_HtmlElement.getAttribute("class")).not.toContain("active");
//           }
//         }
//       );
//     }

//     // The should be 10 rows of claims in the Reject Claims Table with Claims Ids going from 100 to 109.
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     for (let i = 100; i < 110; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + i);
//     }
//   });

//   it('verify that "claimId" input element exists for sorting based on Claim ID value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimId'));

//     let claimIdInputSortDebugElement: DebugElement = claimIdTableHeaderDebugElement.query(By.css('#claimId'));
//     let claimIdInputSortHtmlElement: HTMLElement = claimIdInputSortDebugElement.nativeElement;
//     expect(claimIdInputSortHtmlElement).toBeTruthy();

//     expect(claimIdInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Claim ID ascending sorting in table rows can be done', () => {
//     let claimIds:number[] = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': +getRandomNumberString(5),
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claimIds.push(aClaim.claimId);
//     }

//     // Get Sort Ascending Order of Claim IDs.
//     claimIds.sort((a:number, b:number) => {
//         if (a < b) return -1;
//         else if (a > b) return 1;
//         else return 0;
//       }
//     );

//     // Debug Code
//     /*
//     claimIds.forEach(claimId => {
//         console.log("  claimId = " + claimId);
//       }
//     );
//     */

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimId'));

//     let claimIdInputSortDebugElement: DebugElement = claimIdTableHeaderDebugElement.query(By.css('#claimId'));
//     let claimIdInputSortHtmlElement: HTMLElement = claimIdInputSortDebugElement.nativeElement;
//     expect(claimIdInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Id Ascending Order
//     claimIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Id ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claimIds[i]);
//     }
//   });

//   it('verify Claim ID descending sorting in table rows can be done', () => {
//     let claimIds:number[] = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': +getRandomNumberString(5),
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claimIds.push(aClaim.claimId);
//     }

//     // Get Sort Descending Order of Claim IDs.
//     claimIds.sort((a:number, b:number) => {
//         if (a < b) return 1;
//         else if (a > b) return -1;
//         else return 0;
//       }
//     );

//     // Debug Code
//     /*
//     claimIds.forEach(claimId => {
//         console.log("  claimId = " + claimId);
//       }
//     );
//     */

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimId'));

//     let claimIdInputSortDebugElement: DebugElement = claimIdTableHeaderDebugElement.query(By.css('#claimId'));
//     let claimIdInputSortHtmlElement: HTMLElement = claimIdInputSortDebugElement.nativeElement;
//     expect(claimIdInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Id Ascending Order
//     claimIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click so that rows are in Claim Id Descending Order
//     claimIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Id descending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claimIds[i]);
//     }
//   });

//   it('verify that "claimType" input element exists for sorting based on Claim Type value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimTypeTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimType'));

//     let claimTypeInputSortDebugElement: DebugElement = claimTypeTableHeaderDebugElement.query(By.css('#claimType'));
//     let claimTypeInputSortHtmlElement: HTMLElement = claimTypeInputSortDebugElement.nativeElement;
//     expect(claimTypeInputSortHtmlElement).toBeTruthy();

//     expect(claimTypeInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Claim Type ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': getRandomCapitalLettersOnlyString(4),
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of based on Claim Types.
//     claims.sort((a, b) => {
//         if (a.claimType < b.claimType) return -1;
//         else if (a.claimType > b.claimType) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimTypeTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimType'));

//     let claimTypeInputSortDebugElement: DebugElement = claimTypeTableHeaderDebugElement.query(By.css('#claimType'));
//     let claimTypeInputSortHtmlElement: HTMLElement = claimTypeInputSortDebugElement.nativeElement;
//     expect(claimTypeInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Type Ascending Order
//     claimTypeInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Type ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimTypeRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimType' + i));
//       let claimTypeRowHtmlElement: HTMLElement = claimTypeRowDebugElement.nativeElement;
//       expect(claimTypeRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Type value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(claimTypeRowHtmlElement.innerText.trim()).toEqual(claims[i].claimType);

//     }
//   });

//   it('verify Claim Type descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': getRandomCapitalLettersOnlyString(4),
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of based on Claim Types.
//     claims.sort((a, b) => {
//         if (a.claimType < b.claimType) return 1;
//         else if (a.claimType > b.claimType) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimTypeTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimType'));

//     let claimTypeInputSortDebugElement: DebugElement = claimTypeTableHeaderDebugElement.query(By.css('#claimType'));
//     let claimTypeInputSortHtmlElement: HTMLElement = claimTypeInputSortDebugElement.nativeElement;
//     expect(claimTypeInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Type Ascending Order
//     claimTypeInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Claim Type Descending Order
//     claimTypeInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Type desscending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimTypeRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimType' + i));
//       let claimTypeRowHtmlElement: HTMLElement = claimTypeRowDebugElement.nativeElement;
//       expect(claimTypeRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Type value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(claimTypeRowHtmlElement.innerText.trim()).toEqual(claims[i].claimType);

//     }
//   });

//   it('verify that "hero" input element exists for sorting based on HERO value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let heroTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#hero'));

//     let heroInputSortDebugElement: DebugElement = heroTableHeaderDebugElement.query(By.css('#hero'));
//     let heroInputSortHtmlElement: HTMLElement = heroInputSortDebugElement.nativeElement;
//     expect(heroInputSortHtmlElement).toBeTruthy();

//     expect(heroInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify HERO ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': getRandomHeroString(),
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on HERO values.
//     claims.sort((a, b) => {
//         if (a.hero < b.hero) return -1;
//         else if (a.hero > b.hero) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let heroTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#hero'));

//     let heroInputSortDebugElement: DebugElement = heroTableHeaderDebugElement.query(By.css('#hero'));
//     let heroInputSortHtmlElement: HTMLElement = heroInputSortDebugElement.nativeElement;
//     expect(heroInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in HERO Ascending Order
//     heroInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in HERO ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let heroRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#hero' + i));
//       let heroRowHtmlElement: HTMLElement = heroRowDebugElement.nativeElement;
//       expect(heroRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on HERO value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(heroRowHtmlElement.innerText.trim()).toEqual(claims[i].hero);
//     }
//   });

//   it('verify HERO descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': getRandomHeroString(),
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of of rows based on HERO values.
//     claims.sort((a, b) => {
//         if (a.hero < b.hero) return 1;
//         else if (a.hero > b.hero) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     // Debug Code
//     claims.forEach(claim => {
//         console.log("claim.claimId = " + claim.claimId);
//         console.log("   claim.hero = " + claim.hero);
//       }
//     );

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let heroTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#hero'));

//     let heroInputSortDebugElement: DebugElement = heroTableHeaderDebugElement.query(By.css('#hero'));
//     let heroInputSortHtmlElement: HTMLElement = heroInputSortDebugElement.nativeElement;
//     expect(heroInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in HERO Ascending Order
//     heroInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in HERO Descending Order
//     heroInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in HERO descending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let heroRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#hero' + i));
//       let heroRowHtmlElement: HTMLElement = heroRowDebugElement.nativeElement;
//       expect(heroRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on HERO value.
//       // xpect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(heroRowHtmlElement.innerText.trim()).toEqual(claims[i].hero);
//     }
//   });

//   it('verify that "patientId" input element exists for sorting based on Patient ID value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let patientIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#patientId'));

//     let patientIdInputSortDebugElement: DebugElement = patientIdTableHeaderDebugElement.query(By.css('#patientId'));
//     let patientIdInputSortHtmlElement: HTMLElement = patientIdInputSortDebugElement.nativeElement;
//     expect(patientIdInputSortHtmlElement).toBeTruthy();

//     expect(patientIdInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Patient ID ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': getRandomNumberString(9),
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on Patient ID values.
//     claims.sort((a, b) => {
//         if (a.patientId < b.patientId) return -1;
//         else if (a.patientId > b.patientId) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let patientIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#patientId'));

//     let patientIdInputSortDebugElement: DebugElement = patientIdTableHeaderDebugElement.query(By.css('#patientId'));
//     let patientIdInputSortHtmlElement: HTMLElement = patientIdInputSortDebugElement.nativeElement;
//     expect(patientIdInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Patient ID Ascending Order
//     patientIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Patient ID ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let patientIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#patientId' + i));
//       let patientIdRowHtmlElement: HTMLElement = patientIdRowDebugElement.nativeElement;
//       expect(patientIdRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Patient ID value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(patientIdRowHtmlElement.innerText.trim()).toEqual(claims[i].patientId);
//     }
//   });

//   it('verify Patient ID descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': getRandomNumberString(9),
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Patient ID values.
//     claims.sort((a, b) => {
//         if (a.patientId < b.patientId) return 1;
//         else if (a.patientId > b.patientId) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let patientIdTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#patientId'));

//     let patientIdInputSortDebugElement: DebugElement = patientIdTableHeaderDebugElement.query(By.css('#patientId'));
//     let patientIdInputSortHtmlElement: HTMLElement = patientIdInputSortDebugElement.nativeElement;
//     expect(patientIdInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Patient ID Ascending Order
//     patientIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Patient ID Descending Order
//     patientIdInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Patient ID descending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let patientIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#patientId' + i));
//       let patientIdRowHtmlElement: HTMLElement = patientIdRowDebugElement.nativeElement;
//       expect(patientIdRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Patient ID value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(patientIdRowHtmlElement.innerText.trim()).toEqual(claims[i].patientId);
//     }
//   });

//   it('verify that "claimDate" input element exists for sorting based on Claim Date value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimDate'));

//     let claimDateInputSortDebugElement: DebugElement = claimDateTableHeaderDebugElement.query(By.css('#claimDate'));
//     let claimDateInputSortHtmlElement: HTMLElement = claimDateInputSortDebugElement.nativeElement;
//     expect(claimDateInputSortHtmlElement).toBeTruthy();

//     expect(claimDateInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Claim Date ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': getRandomDate(),
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);

//       // Debug
//       // console.log("aClaim.claimDate = " + aClaim.claimDate);
//     }

//     // Get Sort Ascending Order of rows based on Claim Date values.
//     claims.sort((a, b) => {
//         let aClaimDate = new Date(a.claimDate);
//         let bClaimDate = new Date(b.claimDate);
//         if (aClaimDate.getTime() < bClaimDate.getTime()) return -1;
//         else if (aClaimDate.getTime() > bClaimDate.getTime()) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     // Debug Code
//     /*
//     claims.forEach(claim => {
//         console.log("claim.claimDate = " + claim.claimDate);
//       }
//     );
//     */

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimDate'));

//     let claimDateInputSortDebugElement: DebugElement = claimDateTableHeaderDebugElement.query(By.css('#claimDate'));
//     let claimDateInputSortHtmlElement: HTMLElement = claimDateInputSortDebugElement.nativeElement;
//     expect(claimDateInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Date Ascending Order
//     claimDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Date ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimDateRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimDate' + i));
//       let claimDateRowHtmlElement: HTMLElement = claimDateRowDebugElement.nativeElement;
//       expect(claimDateRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Date value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(claimDateRowHtmlElement.innerText.trim()).toEqual(claims[i].claimDate);
//     }
//   });

//   it('verify Claim Date descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': getRandomDate(),
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Claim Date values.
//     claims.sort((a, b) => {
//         let aClaimDate = new Date(a.claimDate);
//         let bClaimDate = new Date(b.claimDate);
//         if (aClaimDate.getTime() < bClaimDate.getTime()) return 1;
//         else if (aClaimDate.getTime() > bClaimDate.getTime()) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimDate'));

//     let claimDateInputSortDebugElement: DebugElement = claimDateTableHeaderDebugElement.query(By.css('#claimDate'));
//     let claimDateInputSortHtmlElement: HTMLElement = claimDateInputSortDebugElement.nativeElement;
//     expect(claimDateInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Date Ascending Order
//     claimDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Claim Date Descending Order
//     claimDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Date descending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimDateRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimDate' + i));
//       let claimDateRowHtmlElement: HTMLElement = claimDateRowDebugElement.nativeElement;
//       expect(claimDateRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Date value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(claimDateRowHtmlElement.innerText.trim()).toEqual(claims[i].claimDate);
//     }
//   });

//   it('verify that "claimAmount" input element exists for sorting based on Claim Amount value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimAmountTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimAmount'));

//     let claimAmountInputSortDebugElement: DebugElement = claimAmountTableHeaderDebugElement.query(By.css('#claimAmount'));
//     let claimAmountInputSortHtmlElement: HTMLElement = claimAmountInputSortDebugElement.nativeElement;
//     expect(claimAmountInputSortHtmlElement).toBeTruthy();

//     expect(claimAmountInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Claim Amount ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': getRandomDollarAmount(),
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on Claim Amount values.
//     claims.sort((a, b) => {
//         if (a.claimAmount < b.claimAmount) return -1;
//         else if (a.claimAmount > b.claimAmount) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimAmountTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimAmount'));

//     let claimAmountInputSortDebugElement: DebugElement = claimAmountTableHeaderDebugElement.query(By.css('#claimAmount'));
//     let claimAmountInputSortHtmlElement: HTMLElement = claimAmountInputSortDebugElement.nativeElement;
//     expect(claimAmountInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Amount Ascending Order
//     claimAmountInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Amount ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimAmountRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimAmount' + i));
//       let claimAmountRowHtmlElement: HTMLElement = claimAmountRowDebugElement.nativeElement;
//       expect(claimAmountRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Amount value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       // expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + claims[i].claimAmount.toFixed(2).toLocaleString('en-US', { useGrouping: true })); // works sometimes
//       expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + formatNumbertoCommaSeperated(claims[i].claimAmount.toFixed(2)));
//       // expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + claims[i].claimAmount.toFixed(2));
//     }
//   });

//   it('verify Claim Amount desccending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': getRandomDollarAmount(),
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Claim Amount values.
//     claims.sort((a, b) => {
//         if (a.claimAmount < b.claimAmount) return 1;
//         else if (a.claimAmount > b.claimAmount) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let claimAmountTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#claimAmount'));

//     let claimAmountInputSortDebugElement: DebugElement = claimAmountTableHeaderDebugElement.query(By.css('#claimAmount'));
//     let claimAmountInputSortHtmlElement: HTMLElement = claimAmountInputSortDebugElement.nativeElement;
//     expect(claimAmountInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Claim Amount Ascending Order
//     claimAmountInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Claim Amount Descending Order
//     claimAmountInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Claim Amount ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let claimAmountRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimAmount' + i));
//       let claimAmountRowHtmlElement: HTMLElement = claimAmountRowDebugElement.nativeElement;
//       expect(claimAmountRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Claim Amount value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       // expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + claims[i].claimAmount.toFixed(2).toLocaleString('en-US', { useGrouping: true }));
//       expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + formatNumbertoCommaSeperated(claims[i].claimAmount.toFixed(2))); // works sometimes
//       // expect(claimAmountRowHtmlElement.innerText.trim()).toEqual("$" + claims[i].claimAmount.toFixed(2));
//     }
//   });

//   it('verify that "providerName" input element exists for sorting based on Provider value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let providerNameTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#providerName'));

//     let providerNameInputSortDebugElement: DebugElement = providerNameTableHeaderDebugElement.query(By.css('#providerName'));
//     let providerNameInputSortHtmlElement: HTMLElement = providerNameInputSortDebugElement.nativeElement;
//     expect(providerNameInputSortHtmlElement).toBeTruthy();

//     expect(providerNameInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Provider ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': getRandomCapitalLettersOnlyString(20),
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of based on Provider Name values.
//     claims.sort((a, b) => {
//         if (a.providerName < b.providerName) return -1;
//         else if (a.providerName > b.providerName) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let providerNameTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#providerName'));

//     let providerNameInputSortDebugElement: DebugElement = providerNameTableHeaderDebugElement.query(By.css('#providerName'));
//     let providerNameInputSortHtmlElement: HTMLElement = providerNameInputSortDebugElement.nativeElement;
//     expect(providerNameInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Provider Name Ascending Order
//     providerNameInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Provider Name ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let providerNameRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#providerName' + i));
//       let providerNameRowHtmlElement: HTMLElement = providerNameRowDebugElement.nativeElement;
//       expect(providerNameRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Provider Name value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(providerNameRowHtmlElement.innerText.trim()).toEqual(claims[i].providerName);

//     }
//   });

//   it('verify Provider descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': getRandomCapitalLettersOnlyString(20),
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of based on Provider Name values.
//     claims.sort((a, b) => {
//         if (a.providerName < b.providerName) return 1;
//         else if (a.providerName > b.providerName) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let providerNameTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#providerName'));

//     let providerNameInputSortDebugElement: DebugElement = providerNameTableHeaderDebugElement.query(By.css('#providerName'));
//     let providerNameInputSortHtmlElement: HTMLElement = providerNameInputSortDebugElement.nativeElement;
//     expect(providerNameInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Provider Name Ascending Order
//     providerNameInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Provider Name Descending Order
//     providerNameInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Provider Name ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let providerNameRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#providerName' + i));
//       let providerNameRowHtmlElement: HTMLElement = providerNameRowDebugElement.nativeElement;
//       expect(providerNameRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Provider Name value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(providerNameRowHtmlElement.innerText.trim()).toEqual(claims[i].providerName);

//     }
//   });

//   it('verify that "disapprovedBy" input element exists for sorting based on Disapproved By value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedByTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedBy'));

//     let disapprovedByInputSortDebugElement: DebugElement = disapprovedByTableHeaderDebugElement.query(By.css('#disapprovedBy'));
//     let disapprovedByInputSortHtmlElement: HTMLElement = disapprovedByInputSortDebugElement.nativeElement;
//     expect(disapprovedByInputSortHtmlElement).toBeTruthy();

//     expect(disapprovedByInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Disapproved By ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '7/5/2017',
//         'claimAmount': 100.02,
//         'providerName': 'CLEVELAND GEN',
//         'disapprovedBy': getRandomCapitalLettersOnlyString(13),
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of based on Disapproved By values.
//     claims.sort((a, b) => {
//         if (a.disapprovedBy < b.disapprovedBy) return -1;
//         else if (a.disapprovedBy > b.disapprovedBy) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedByTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedBy'));

//     let disapprovedByInputSortDebugElement: DebugElement = disapprovedByTableHeaderDebugElement.query(By.css('#disapprovedBy'));
//     let disapprovedByInputSortHtmlElement: HTMLElement = disapprovedByInputSortDebugElement.nativeElement;
//     expect(disapprovedByInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Disapproved By Ascending Order
//     disapprovedByInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Disapproved By ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let disapprovedByRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#disapprovedBy' + i));
//       let disapprovedByRowHtmlElement: HTMLElement = disapprovedByRowDebugElement.nativeElement;
//       expect(disapprovedByRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Disapproved By value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(disapprovedByRowHtmlElement.innerText.trim()).toEqual(claims[i].disapprovedBy);
//     }
//   });

//   it('verify Disapproved By descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'PROF',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '7/5/2017',
//         'claimAmount': 100.02,
//         'providerName': 'CLEVELAND GEN',
//         'disapprovedBy': getRandomCapitalLettersOnlyString(13),
//         'disapprovedDate': '01/11/2017',
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of based on Disapproved By values.
//     claims.sort((a, b) => {
//         if (a.disapprovedBy < b.disapprovedBy) return 1;
//         else if (a.disapprovedBy > b.disapprovedBy) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedByTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedBy'));

//     let disapprovedByInputSortDebugElement: DebugElement = disapprovedByTableHeaderDebugElement.query(By.css('#disapprovedBy'));
//     let disapprovedByInputSortHtmlElement: HTMLElement = disapprovedByInputSortDebugElement.nativeElement;
//     expect(disapprovedByInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Disapproved By Ascending Order
//     disapprovedByInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Disapproved By Descending Order
//     disapprovedByInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Disapproved By ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let disapprovedByRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#disapprovedBy' + i));
//       let disapprovedByRowHtmlElement: HTMLElement = disapprovedByRowDebugElement.nativeElement;
//       expect(disapprovedByRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Disapproved By value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(disapprovedByRowHtmlElement.innerText.trim()).toEqual(claims[i].disapprovedBy);
//     }
//   });

//   it('verify that "disapprovedDate" input element exists for sorting based on Disapprove Date value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedDate'));

//     let disapprovedDateInputSortDebugElement: DebugElement = disapprovedDateTableHeaderDebugElement.query(By.css('#disapprovedDate'));
//     let disapprovedDateInputSortHtmlElement: HTMLElement = disapprovedDateInputSortDebugElement.nativeElement;
//     expect(disapprovedDateInputSortHtmlElement).toBeTruthy();

//     expect(disapprovedDateInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Disapprove Date ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '03/17/2010',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': getRandomDate(),
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on Disapprove Date values.
//     claims.sort((a, b) => {
//         let aDisapprovedDate = new Date(a.disapprovedDate);
//         let bDisapprovedDate = new Date(b.disapprovedDate);
//         if (aDisapprovedDate.getTime() < bDisapprovedDate.getTime()) return -1;
//         else if (aDisapprovedDate.getTime() > bDisapprovedDate.getTime()) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedDate'));

//     let disapprovedDateInputSortDebugElement: DebugElement = disapprovedDateTableHeaderDebugElement.query(By.css('#disapprovedDate'));
//     let disapprovedDateInputSortHtmlElement: HTMLElement = disapprovedDateInputSortDebugElement.nativeElement;
//     expect(disapprovedDateInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Disapprove Date Ascending Order
//     disapprovedDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Disapproved Date ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let disapprovedDateRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#disapprovedDate' + i));
//       let disapprovedDateRowHtmlElement: HTMLElement = disapprovedDateRowDebugElement.nativeElement;
//       expect(disapprovedDateRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Disapprove Date value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(disapprovedDateRowHtmlElement.innerText.trim()).toEqual(claims[i].disapprovedDate);
//     }
//   });

//   it('verify Disapprove Date descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '03/17/2010',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': getRandomDate(),
//         'reason': 1692,
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Disapprove Date values.
//     claims.sort((a, b) => {
//         let aDisapprovedDate = new Date(a.disapprovedDate);
//         let bDisapprovedDate = new Date(b.disapprovedDate);
//         if (aDisapprovedDate.getTime() < bDisapprovedDate.getTime()) return 1;
//         else if (aDisapprovedDate.getTime() > bDisapprovedDate.getTime()) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let disapprovedDateTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#disapprovedDate'));

//     let disapprovedDateInputSortDebugElement: DebugElement = disapprovedDateTableHeaderDebugElement.query(By.css('#disapprovedDate'));
//     let disapprovedDateInputSortHtmlElement: HTMLElement = disapprovedDateInputSortDebugElement.nativeElement;
//     expect(disapprovedDateInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Disapprove Date Ascending Order
//     disapprovedDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Disapprove Date Descending Order
//     disapprovedDateInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Disapproved Date ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let disapprovedDateRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#disapprovedDate' + i));
//       let disapprovedDateRowHtmlElement: HTMLElement = disapprovedDateRowDebugElement.nativeElement;
//       expect(disapprovedDateRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Disapprove Date value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(disapprovedDateRowHtmlElement.innerText.trim()).toEqual(claims[i].disapprovedDate);
//     }
//   });

//   it('verify that "reason" input element exists for sorting based on Reason value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let reasonTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#reason'));

//     let reasonInputSortDebugElement: DebugElement = reasonTableHeaderDebugElement.query(By.css('#reason'));
//     let reasonInputSortHtmlElement: HTMLElement = reasonInputSortDebugElement.nativeElement;
//     expect(reasonInputSortHtmlElement).toBeTruthy();

//     expect(reasonInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Reason ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': getRandomNumberString(3),
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on Reason values.
//     claims.sort((a, b) => {
//         if (a.reason < b.reason) return -1;
//         else if (a.reason > b.reason) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     // Debug Code
//     /*
//     claims.forEach(claim => {
//         console.log("  claim.reason = " + claim.reason);
//       }
//     );
//     */

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let reasonTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#reason'));

//     let reasonInputSortDebugElement: DebugElement = reasonTableHeaderDebugElement.query(By.css('#reason'));
//     let reasonInputSortHtmlElement: HTMLElement = reasonInputSortDebugElement.nativeElement;
//     expect(reasonInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Reason Ascending Order
//     reasonInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Debug Code
//     /*
//     component.claimsData.forEach(componentClaimData => {
//         console.log("  componentClaimData.reason = " + componentClaimData.reason);
//       }
//     );
//     */

//     // Check to make sure that the rows in the table are in Reason ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let reasonRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#reason' + i));
//       let reasonRowHtmlElement: HTMLElement = reasonRowDebugElement.nativeElement;
//       expect(reasonRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Reason value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       // console.log("reason" + i + " = " + reasonRowHtmlElement.innerText.trim());
//       expect(reasonRowHtmlElement.innerText.trim()).toEqual("" + claims[i].reason);
//     }
//   });

//   it('verify Reason descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': getRandomNumberString(3),
//         'explanation': 'Out of system payments',
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Reason values.
//     claims.sort((a, b) => {
//         if (a.reason < b.reason) return 1;
//         else if (a.reason > b.reason) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     // Debug Code
//     /*
//     claims.forEach(claim => {
//         console.log("  claim.reason = " + claim.reason);
//       }
//     );
//     */

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let reasonTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#reason'));

//     let reasonInputSortDebugElement: DebugElement = reasonTableHeaderDebugElement.query(By.css('#reason'));
//     let reasonInputSortHtmlElement: HTMLElement = reasonInputSortDebugElement.nativeElement;
//     expect(reasonInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Reason Ascending Order
//     reasonInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click again so that rows are in Reason Descending Order
//     reasonInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Debug
//     /*
//     component.claimsData.forEach(componentClaimData => {
//         console.log("  componentClaimData.reason = " + componentClaimData.reason);
//       }
//     );
//     */

//     // Check to make sure that the rows in the table are in Reason ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let reasonRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#reason' + i));
//       let reasonRowHtmlElement: HTMLElement = reasonRowDebugElement.nativeElement;
//       expect(reasonRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Reason value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       // console.log("reason" + i + " = " + reasonRowHtmlElement.innerText.trim());
//       expect(reasonRowHtmlElement.innerText.trim()).toEqual("" + claims[i].reason);
//     }
//   });

//   it('verify that "explanation" input element exists for sorting based on Explanation value', () => {
//     setClaimsDataWithNoClaimBeingSelected();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let explanationTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#explanation'));

//     let explanationInputSortDebugElement: DebugElement = explanationTableHeaderDebugElement.query(By.css('#explanation'));
//     let explanationInputSortHtmlElement: HTMLElement = explanationInputSortDebugElement.nativeElement;
//     expect(explanationInputSortHtmlElement).toBeTruthy();

//     expect(explanationInputSortHtmlElement.getAttribute("class")).toEqual("sort");
//   });

//   it('verify Explanation ascending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': getRandomCapitalLettersOnlyString(80),
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Ascending Order of rows based on Explanation values.
//     claims.sort((a, b) => {
//         if (a.explanation < b.explanation) return -1;
//         else if (a.explanation > b.explanation) return 1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let explanationTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#explanation'));

//     let explanationInputSortDebugElement: DebugElement = explanationTableHeaderDebugElement.query(By.css('#explanation'));
//     let explanationInputSortHtmlElement: HTMLElement = explanationInputSortDebugElement.nativeElement;
//     expect(explanationInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Explanation Ascending Order
//     explanationInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Explanation ascending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let explanationRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#explanation' + i));
//       let explanationRowHtmlElement: HTMLElement = explanationRowDebugElement.nativeElement;
//       expect(explanationRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Explanation value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(explanationRowHtmlElement.innerText.trim()).toEqual(claims[i].explanation);
//     }
//   });

//   it('verify Explanation descending sorting in table rows can be done', () => {
//     let claims  = [];

//     for (let i = 0; i < 120; i++) {
//       let aClaim = {
//         'claimId': i,
//         'claimStatus': 'REJECTED',
//         'claimType': 'DENT',
//         'hero': 'Y',
//         'patientId': '362873227',
//         'claimDate': '07/05/2017',
//         'claimAmount': 100.02,
//         'providerName': 'MEMORIAL HOSP',
//         'disapprovedBy': 'Robin',
//         'disapprovedDate': '01/11/2017',
//         'reason': '169',
//         'explanation': getRandomCapitalLettersOnlyString(80),
//         // 'comments': 'updated recently',
//         // 'history': 'processed'
//       }

//       component.claimsData.push(aClaim);
//       claims.push(aClaim);
//     }

//     // Get Sort Descending Order of rows based on Explanation values.
//     claims.sort((a, b) => {
//         if (a.explanation < b.explanation) return 1;
//         else if (a.explanation > b.explanation) return -1;
//         else return 0;
//       }
//     );

//     fixture.detectChanges();

//     let tableComponentDebugElement: DebugElement = fixture.debugElement.query(By.css('#table'));
//     let dataTableDebugElement: DebugElement = tableComponentDebugElement.query(By.css('#datatable'));
//     let tableHeaderDebugElement: DebugElement = dataTableDebugElement.query(By.css('thead'));
//     let explanationTableHeaderDebugElement: DebugElement = tableHeaderDebugElement.query(By.css('#explanation'));

//     let explanationInputSortDebugElement: DebugElement = explanationTableHeaderDebugElement.query(By.css('#explanation'));
//     let explanationInputSortHtmlElement: HTMLElement = explanationInputSortDebugElement.nativeElement;
//     expect(explanationInputSortHtmlElement).toBeTruthy();

//     // Click so that rows are in Explanation Ascending Order
//     explanationInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Click so that rows are in Explanation Descending Order
//     explanationInputSortHtmlElement.click();
//     fixture.detectChanges();

//     // Check to make sure that the rows in the table are in Explanation descending order.
//     for (let i = 0; i < 10; i++) {
//       let claimIdRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#claimId' + i));
//       let claimIdRowHtmlElement: HTMLElement = claimIdRowDebugElement.nativeElement;
//       expect(claimIdRowHtmlElement).toBeTruthy();

//       let explanationRowDebugElement: DebugElement = dataTableDebugElement.query(By.css('#explanation' + i));
//       let explanationRowHtmlElement: HTMLElement = explanationRowDebugElement.nativeElement;
//       expect(explanationRowHtmlElement).toBeTruthy();

//       // The below is not necessarily so due to ordering being based on Explanation value.
//       // expect(claimIdRowHtmlElement.innerText.trim()).toEqual("" + claims[i].claimId);

//       expect(explanationRowHtmlElement.innerText.trim()).toEqual(claims[i].explanation);
//     }
//   });

// });
