import { Component, Input, OnInit } from '@angular/core';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { ProcessAndPrintService } from './service/process.component.service';
import { Claims } from '../models/Claims';
import {
    RequestOptions,
    URLSearchParams,
    Headers,
    Response,
    Http,
    ResponseContentType
} from '@angular/http';
import { environment } from '../../../environments/environment';
@Component({
    selector: 'app-process-and-print',
    templateUrl: 'process-and-print.component.html',
    styleUrls: ['./process-and-print.component.scss']
})
export class ProcessAndPrintComponent implements OnInit {
    @Input() claims: any[];
    getParam = new URLSearchParams();
    searchheaders = new Headers();

    constructor(
        private sharedData: SharedDataService,
        private processPrint: ProcessAndPrintService
    ) { }

    ngOnInit() {
        console.log('Inside of ProcessAndPrintComponent.ngOnInit()!');
        this.searchheaders.append('Content-Type', 'application/json');
        this.claims = this.sharedData.storage;

        this.claims = this.claims.map(claim => claim.claimId);
        const options = new RequestOptions({
            headers: this.searchheaders,
            body: this.claims,
            responseType: ResponseContentType.Text
        });
        console.log(this.claims);
        this.processPrint
            .print(environment.nodeserver + '/claims/print/', options)
            .subscribe(
            data => {
                const file = new Blob([String.fromCharCode.apply(null, data.data)], {
                    type: 'application/pdf'
                });
                const fileUrl = URL.createObjectURL(file);
                console.log(JSON.stringify(String.fromCharCode.apply(null, data.data)));
                window.open('http://SERVER.DOMAIN' + data.pathName.replace('/usr/share/tomcat/latest/webapps/generatedReports', ''));
            },
            () => console.log('back in console')
            );
    }
}
