import { Component, Input, OnInit } from '@angular/core';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { PrintService } from './service/print.component.service';
import { Claims } from '../models/Claims';
import {
  RequestOptions,
  URLSearchParams,
  Headers,
  Response,
  Http,
  ResponseContentType
} from '@angular/http';
import { environment } from '../../../environments/environment';
@Component({
  selector: 'app-print',
  templateUrl: 'print.component.html',
  styleUrls: ['./print.component.scss']
})
export class PrintComponent implements OnInit {
  @Input() public claims: any[] = [];
  public claimsTemp: any[] = [];
  @Input() public innerText = 'Default Button';
  @Input() public id = '';
  @Input() public disabled = false;
  @Input() btnClass = 'button primary';
  @Input() public filter = true;
  claimIds: any = [];
  constructor(
    private sharedData: SharedDataService,
    private processPrint: PrintService
  ) {}

  ngOnInit() {}
  onClick() {
    if (this.disabled) {
      return;
    }
    const getParam = new URLSearchParams();
    const searchheaders = new Headers();
    searchheaders.append('Content-Type', 'application/json');
    if (this.filter) {
      this.claimsTemp = this.claims.filter(claim => claim.selected);
    } else {
      this.claimsTemp = this.claims;
    }
    this.claimIds = this.claimsTemp.map(claim => claim.claimId);
    // console.log(this.claimsTemp);
    const options = new RequestOptions({
      headers: searchheaders,
      body: this.claimIds,
      responseType: ResponseContentType.Text
    });
    // console.log(this.claimIds);
    this.processPrint
      .print(environment.nodeserver + '/claims/print/', options)
      .subscribe(
        data => {
          const file = new Blob([String.fromCharCode.apply(null, data.data)], {
            type: 'application/pdf'
          });
          const fileUrl = URL.createObjectURL(file);
          console.log(
            JSON.stringify(String.fromCharCode.apply(null, data.data))
          );
          window.open(
            'http://SERVER.DOMAIN' +
              data.pathName.replace(
                '/usr/share/tomcat/latest/webapps/generatedReports',
                ''
              )
          );
        },
        () => console.log('back in console')
      );
  }
}
