import { Observable } from 'rxjs/Observable';

import { PrintComponent } from './print.component'; // Import Menu Component
import { PrintService } from './service/print.component.service';

describe('PrintComponent', () => {
  let component: PrintComponent;
  let processPrint: PrintService;
  beforeEach(() => {
    processPrint = new PrintService(null);
    component = new PrintComponent(null, processPrint);
  });
  it('print should be created', () => {
    expect(component).toBeTruthy();
  });

  it('On click of the print button it should print', () => {
    spyOn(processPrint, 'print').and.callFake(() => {
      return new Observable(observer => observer);
    });
    component.onClick();
    if (expect(processPrint.print).toHaveBeenCalled()) {
      expect(window.open).toHaveBeenCalled();
    }
  });
});
