import { Component, OnInit, Input } from '@angular/core';
import { SharedDataService } from '../../shared/service/shared-data.service';
import { Router } from '@angular/router';

@Component({
	selector: 'nav-button',
	templateUrl: './nav-button.component.html',
	styleUrls: ['./nav-button.component.scss']
})
export class NavButtonComponent implements OnInit {
	@Input() public claims: any[];
	@Input() public innerText = 'Default Button';
	@Input() public url = '';
	@Input() public id = '';
	@Input() public disabled = false;
	@Input() public filter = true;
	@Input() btnClass = 'button primary';
	constructor(private sharedData: SharedDataService, private router: Router) { }

	ngOnInit() {
	}

	onClick() {
		if (this.disabled) {
			return;
		}
		if (this.filter) {
			this.sharedData.storage = this.claims.filter(claim => claim.selected);
		} else {
			this.sharedData.storage = this.claims;
		}

		this.router.navigate([this.url]);
	}
}
