import { Component, OnInit, Input, DoCheck, OnChanges } from '@angular/core';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { Observable } from 'rxjs/Observable';

import { Permissions } from './menu.model';
import { WindowRefService } from './../../../app/window-ref.service';
@Component({
  selector: 'app-menu',
  templateUrl: './menu.component.html',
  styleUrls: ['./menu.component.scss']
})
export class MenuComponent implements OnInit, DoCheck {
  // test code
  homeFocus = false;
  claimsFocus = false;
  reportsFocus = false;
  toolsFocus = false;
  helpFocus = false;
  // end of test code
  @Input() userName: String;
  public claimMenuPermissions;
  public reportMenuPermissions;
  public toolsMenuPermissions;
  public userAdministrationPermission;
  public stationMaintenancePermission;
  permissions = new Permissions();
  constructor(
    private router: Router,
    private location: Location,
    private windowRef: WindowRefService
  ) {
    // console.log('**** MenuComponent.constructor: this.userName = ' + this.userName);
    const role = sessionStorage.getItem('role');

    if (role == null) {
      this.location.replaceState('/');
      this.router.navigate(['login']);
    }
  }

  ngOnInit() {
    if (this.userName === undefined) {
      this.userName = sessionStorage.getItem('userName');
    }

    this.getUserPermissions();
  }

  logout() {
    sessionStorage.clear();
    this.location.replaceState('/');
    this.router.navigate(['login']);
  }

  // Gets the permission from the session, It is used in the html to show and hide things
  getUserPermissions() {
    if (!!sessionStorage.getItem('userInfo')) {
      this.permissions = JSON.parse(sessionStorage.getItem('userInfo'))[
        'permissions'
      ];
    }
    // setting the user adminstration label if atleast one of the sub links are enabled
    if (
      !!this.permissions.toolsMenu &&
      (this.permissions.toolsMenu['createUser'] ||
        this.permissions.toolsMenu['searchModifyUser'] ||
        this.permissions.toolsMenu['createUserRequest'] ||
        this.permissions.toolsMenu['modifyUserRequest'] ||
        this.permissions.toolsMenu['viewUserAccountRequests'] ||
        this.permissions.toolsMenu['privacyRestrictions'])
    ) {
      this.userAdministrationPermission = true;
    } else {
      this.userAdministrationPermission = false;
    }
    // setting the station maintenance label if atleast one of the sub links are enabled
    if (
      !!this.permissions.toolsMenu &&
      (this.permissions.toolsMenu['addStation'] ||
        this.permissions.toolsMenu['searchStation'])
    ) {
      this.stationMaintenancePermission = true;
    } else {
      this.stationMaintenancePermission = false;
    }
  }
  ngDoCheck() {
    this.onFocusCheck().subscribe(bool => {
      if (bool) {
        this.windowRef.nativeWindow.onclick = () => {
          this.onClearMenu();
        };
      } else {
        this.windowRef.nativeWindow.onclick = undefined;
      }
    });
  }

  focus(focus: string) {
    this.homeFocus = false;
    this.claimsFocus = false;
    this.reportsFocus = false;
    this.toolsFocus = false;
    this.helpFocus = false;
    this[focus] = true;
  }
  onClearMenu() {
    this.focus(undefined);
  }
  onFocusCheck(): Observable<boolean> {
    const bools = [
      this.homeFocus,
      this.claimsFocus,
      this.reportsFocus,
      this.toolsFocus,
      this.helpFocus
    ];
    return new Observable(observer =>
      observer.next(bools.some(b => b === true))
    );
  }
}
