import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MenuComponent } from './menu.component';
import { UserNameService } from './service/menu.component.service';
import { HttpModule } from '@angular/http';
import { RouterTestingModule } from '@angular/router/testing';
import { DebugElement, SimpleChanges } from '@angular/core';
import { By } from '@angular/platform-browser';

describe('MenuComponent', () => {
  let component: MenuComponent;
  let fixture: ComponentFixture<MenuComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, RouterTestingModule],
        declarations: [MenuComponent],
        providers: [UserNameService]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(MenuComponent);
    component = fixture.componentInstance;

    const userInfo = {
      permissions: {
        claimsMenu: {
          paymentError: 'true',
          unmatchedPayments: 'true',
          inprocess: 'true',
          aged: 'true',
          searchClaim: 'true',
          rejectClaims: 'true',
          awaitingProcessing: 'true'
        },
        reportsMenu: {
          claimsAwaitingProcessing: 'true',
          reroutedClaims: 'true',
          claimsInprocessSummary: 'true',
          vistAError: 'true',
          claimsCompleted: 'true',
          CPEReport: 'true',
          claimsCompletedSummary: 'true',
          claimsInprocess: 'true',
          outOfSystemPaymentsSummary: 'true',
          BPPR16: 'true',
          outOfSystemPayments: 'true',
          claimsAwaitingProcessingSummary: 'true',
          feeReport: 'true'
        }
      }
    };

    sessionStorage.setItem('userInfo', JSON.stringify(userInfo));
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should have a link to navigate to "search claim" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#searchClaim')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "paymentError" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#paymentError')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
  it('should have a link to navigate to "unmatchedPayments" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#unmatchedPayments')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
  it('should have a link to navigate to "inprocess" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#inprocess')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
  it('should have a link to navigate to "aged" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#aged')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "rejectClaims" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#rejectClaims')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "awaitingProcessing" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#awaitingProcessing')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "claimsAwaitingProcessing" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimsAwaitingProcessing')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "reroutedClaims" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#reroutedClaims')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "claimsInprocessSummary" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimsInprocessSummary')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "vistAError" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#vistAError')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "claimsCompleted" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimsCompleted')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "CPEReport" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#CPEReport')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "claimsCompletedSummary" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimsCompletedSummary')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "claimsInprocess" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#claimsInprocess')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });

  it('should have a link to navigate to "outOfSystemPaymentsSummary" page', () => {
    const debugElement: DebugElement = fixture.debugElement.query(
      By.css('#outOfSystemPaymentsSummary')
    );
    const htmlElement: HTMLElement = debugElement.nativeElement;

    expect(htmlElement).toBeTruthy();
    expect(htmlElement.hidden).toBe(false);
  });
});
