import { Component, OnInit, Input } from '@angular/core';
import { Router } from '@angular/router';

@Component({
	selector: 'card-component',
	templateUrl: './card.component.html',
	styleUrls: ['./card.component.scss']
})
export class CardComponent implements OnInit {
	public properties;
	@Input() public item: any;
	@Input() public id: string;
	@Input() public title: string;
	@Input() public cardOptions: any = { id: { name: 'ID' } };
	constructor(private router: Router) { }

	ngOnInit() {

	}

	ngOnChanges() {
		this.properties = !!this.item ? Object.getOwnPropertyNames(this.item) : [];
	}

	isHidden(property: string) {
		if (!!this.cardOptions[property]) {
			return this.cardOptions[property].hide === true;
		} else {
			return false;
		}
	}
	isDefined(property: string) {
		return !!this.item[property];
	}
	nameOf(property: string) {
		if (!!this.cardOptions[property] && !!this.cardOptions[property].name) {
			return this.cardOptions[property].name;
		} else {
			return property;
		}
	}
	valueOf(property: string) {
		if (this.isDefined(property)) {
			return this.item[property];
		}
		return 'NA'
	}
}
