import { Component, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'assign',
    templateUrl: './assign.component.html',
    styleUrls: ['./assign.component.scss']
})
export class AssignComponent {
    @Input() public leftObjects: any[];
    @Input() public leftTitle: String = 'Left';
    @Input() public rightObjects: any[];
    @Input() public rightTitle: String = 'Right';
    @Input() public id = '' + Math.random();
    @Input() public disabled = false;
    @Output() notify: EventEmitter<any[]> = new EventEmitter<any[]>();
    constructor() { }

    assignAll() {
        this.rightObjects = this.rightObjects.concat(this.leftObjects);
        this.leftObjects = [];
        this.notify.emit(this.rightObjects);
    }
    assign() {
        const selected = this.getSelectValues(document.getElementById('leftSelect' + this.id));
        this.rightObjects = this.rightObjects.concat(selected);
        this.leftObjects = this.leftObjects.filter(x => selected.indexOf(x) === -1);
        this.notify.emit(this.rightObjects);
    }
    remove() {
        const selected = this.getSelectValues(document.getElementById('rightSelect' + this.id));
        this.leftObjects = this.leftObjects.concat(selected);
        this.rightObjects = this.rightObjects.filter(x => selected.indexOf(x) === -1);
        this.notify.emit(this.rightObjects);
    }
    removeAll() {
        this.leftObjects = this.leftObjects.concat(this.rightObjects);
        this.rightObjects = [];
        this.notify.emit(this.rightObjects);
    }

    // Return an array of the selected opion values
    // select is an HTML select element
    getSelectValues(select) {
        const result = [];
        const options = select && select.options;
        for (let i = 0, iLen = options.length; i < iLen; i++) {
            if (options[i].selected) {
                result.push(options[i].value || options[i].text);
            }
        }
        return result;
    }
}
