import { Component, OnInit, ElementRef, ViewChild } from '@angular/core';
import { ScriptService } from 'app/shared/scriptLoader/script.service';

@Component({
  selector: 'app-claims-completed',
  templateUrl: './claims-completed.component.html',
  styleUrls: ['./claims-completed.component.scss']
})
export class ClaimsCompletedComponent implements OnInit {
  @ViewChild('sdate') startDateField: ElementRef;
  @ViewChild('edate') endDateField: ElementRef;
  model: any = { project: 'all', stations: [], format: 'pdf', sortBy: 'date', date: 'recieved' };
  stations = ['station1', 'station2'];
  constructor(private script: ScriptService) { }

  ngOnInit() {
    this.script.load('datepicker').then(data => {
    }).catch(error => console.log(error));
  }
  onSubmit() { }

  saveStartDate() {
    this.model.startDate = this.startDateField.nativeElement.value;
  }

  saveEndDate() {
    this.model.endDate = this.endDateField.nativeElement.value;
  }
}
