import { AuthenticationParams } from '../../shared/models/AuthenticationParams';
import { AuthenticationResponse } from '../../shared/models/AuthenticationResponse';
import { Injectable } from '@angular/core';
import { Http, Response, Headers, Jsonp, RequestOptions, URLSearchParams } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/catch';
import { environment } from '../../../environments/environment';

@Injectable()
export class AuthenticationService {
	constructor(private http: Http) { }

	public getAuthenticationParams(): Observable<AuthenticationParams> {
		var responseData = this.http.get(environment.nodeserver + '/login/authParams')
			.map((res: Response) => <AuthenticationParams>res.json());

		return responseData;
	}

	public submitForAuthentication(requestParams): Observable<AuthenticationResponse> {
		var responseData = this.http.get('http://localhost:4000/authenticate', requestParams)
			.map((res: Response) => <any>res.json());
		return responseData;
	}

	public authenticateAndGetRoles(requestParams) {
		// var responseData =  this.http.post(environment.nodeserver + "/login/roles",requestParams)
		// .map((res: Response) => <any>res.json());
		return this.http.post(environment.nodeserver + '/login/roles', requestParams)
			.map((res: Response) => res.json())
			.catch((error: Response) => Observable.throw(error.json));
	}

}
