import { Component, OnInit } from '@angular/core';
import { AuthenticationService } from './service/login.service';
import { AuthenticationParams } from '../shared/models/AuthenticationParams';
import { AuthenticationResponse } from '../shared/models/AuthenticationResponse';
import { UserInfo } from '../shared/models/UserInfo';
import { Router } from '@angular/router';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { Location } from '@angular/common';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss']
})
export class LoginComponent implements OnInit {
  public authenticationParams: AuthenticationParams;
  public userInfo: UserInfo;
  public usrInfo: UserInfo;
  public getParam = new URLSearchParams();
  public headers = new Headers();
  public authenticationResponse: AuthenticationResponse = new AuthenticationResponse(
    '1000'
  );
  public userId: any;
  public selectedRole = '';
  constructor(
    private authenticationService: AuthenticationService,
    private router: Router,
    private location: Location
  ) {}
  ngOnInit() {
    this.authenticationService
      .getAuthenticationParams()
      .subscribe(
        data => (this.authenticationParams = data),
        error => alert(error),
        () =>
          console.log(
            'AuthenticationParams are :' +
              JSON.stringify(this.authenticationParams)
          )
      );
  }

  checkRole() {
    if (this.selectedRole !== '') {
      this.authenticationResponse.c = this.selectedRole;
      this.getUserRoles();
    }
  }

  getUserRoles() {
    this.getParam = new URLSearchParams();
    this.headers.append('Content-Type', 'application/json');
    const options = new RequestOptions({
      headers: this.headers,
      body: this.authenticationResponse
    });

    this.authenticationService
      .authenticateAndGetRoles(options)
      .subscribe(
        data => (this.usrInfo = data),
        error => alert(error),
        () => ((this.userInfo = this.usrInfo), this.redirect())
      );
  }

  redirect() {
    if (this.userInfo.userRoles !== undefined) {
      this.router.navigate(['home']);
      sessionStorage.setItem('role', this.userInfo.userRoles.length.toString());
      sessionStorage.setItem('userName', this.userInfo.userName);
      sessionStorage.setItem('lastLogin', this.userInfo.lastLogin);
      sessionStorage.setItem(
        'userRole',
        JSON.stringify(this.userInfo.userRoles)
      );
      sessionStorage.setItem('userInfo', JSON.stringify(this.userInfo));
      sessionStorage.setItem('visns', this.userInfo.userFacilityData.visns);
      sessionStorage.setItem(
        'privacyRestrictions',
        this.userInfo.userFacilityData.privacyRestrictions
      );
    } else {
      this.router.navigate(['loginError']);
    }
  }

  decline() {
    sessionStorage.clear();
    this.location.replaceState('/');
    this.router.navigate(['loginError']);
  }
}
