import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { LoginComponent } from './login.component';
import { HttpModule } from '@angular/http';
import { RouterTestingModule } from '@angular/router/testing';
import { AuthenticationService } from './service/login.service';
import { inject } from '@angular/core/testing';
import { FormsModule } from '@angular/forms';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/observable/from';
import { Headers, RequestOptions, URLSearchParams } from '@angular/http';
import { UserInfo } from '../shared/models/UserInfo';
import { UserFacilityData } from '../shared/models/UserFacilityData';

describe('LoginComponent', () => {
  let component: LoginComponent;
  let fixture: ComponentFixture<LoginComponent>;
  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [HttpModule, RouterTestingModule, FormsModule],
        declarations: [LoginComponent],
        providers: [AuthenticationService]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(LoginComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  // testing if the component is created properly
  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  // testing the checkRole() method
  it('should set the value of "authenticationResponse.c" with "selectedRole"', () => {
    component.selectedRole = '1000';
    component.checkRole();
    expect(component.authenticationResponse.c).toBe('1000');
  });

  // testing getUserRoles() method
  it(
    'should make the rest call and get the user information',
    inject([AuthenticationService], authenticationService => {
      const userFacilityData: UserFacilityData = new UserFacilityData();
      const userInfo: UserInfo = new UserInfo([], '', '', '', userFacilityData);

      spyOn(
        authenticationService,
        'authenticateAndGetRoles'
      ).and.callFake(() => {
        return Observable.from([userInfo]);
      });

      component.getUserRoles();
      expect(component.userInfo).toBeTruthy();
    })
  );

  // testing the decline method()
  it('the session storage should be empty', () => {
    component.decline();
    expect(sessionStorage.length).toBe(0);
  });
});
