import { Component, OnInit, Input } from '@angular/core';
import { Station } from './model/Station';
import { VisnClaims } from './model/VisnClaims';
import { TotalClaims } from './model/TotalClaims';
import { UserStations } from './model/UserStations';
import { FormsModule } from '@angular/forms';
import { UserInfo } from '../shared/models/UserInfo';
import { ClaimCountDetails } from '../shared/models/ClaimCountDetails';
import { UserFacilityData } from '../shared/models/UserFacilityData';

const userName: String = '';
@Component({
  selector: 'app-home',
  templateUrl: './home.component.html'
})
export class HomeComponent implements OnInit {
  checkMarkedStationsShownInAssignStationsTable: String[];
  userName: String;
  lastLogin: String;
  roles: String = '';
  userRoles: any;
  userInfo: UserInfo;
  visnClaimCounts: ClaimCountDetails;
  stationsClaimCounts: ClaimCountDetails[] = [];
  userFacilityData: UserFacilityData;
  private activeStations: string[] = [];
  public updatedActiveStationsList: String;
  public visnClaims: VisnClaims;
  private totalClaims: TotalClaims;
  userStations: UserStations;
  totalClaimsAssigned = 0;
  totalClaimsAwaiting = 0;
  totalClaimsInProcess = 0;
  totalClaimsRejected = 0;
  totalClaimsInError = 0;
  homePermission;

  constructor() {}

  ngOnInit() {
    this.setDataTable();
    this.getUserPermissions();
  }

  setDataTable() {
    this.setUserInfo();
    this.setRoles();

    if (sessionStorage.getItem('activeStations')) {
      const temp: string[] = sessionStorage
        .getItem('activeStations')
        .split(',');
      this.activeStations = temp;

      let iterator = 0;
      for (
        let i = 0;
        i < this.userInfo.userFacilityData.claimCountDetails.length;
        i++
      ) {
        if (
          this.userInfo.userFacilityData.claimCountDetails[i].stationNumber ===
          'VISN'
        ) {
          this.visnClaimCounts = this.userInfo.userFacilityData.claimCountDetails[
            i
          ];
        } else {
          this.stationsClaimCounts[
            iterator
          ] = this.userInfo.userFacilityData.claimCountDetails[i];
          if (
            this.activeStations.indexOf(
              this.stationsClaimCounts[iterator].stationNumber
            ) > -1
          ) {
            this.stationsClaimCounts[iterator].activedChecked = true;
          }
          iterator++;
        }
      }
    } else {
      let iterator = 0;
      for (
        let i = 0;
        i < this.userInfo.userFacilityData.claimCountDetails.length;
        i++
      ) {
        if (
          this.userInfo.userFacilityData.claimCountDetails[i].stationNumber ===
          'VISN'
        ) {
          this.visnClaimCounts = this.userInfo.userFacilityData.claimCountDetails[
            i
          ];
        } else {
          this.stationsClaimCounts[
            iterator
          ] = this.userInfo.userFacilityData.claimCountDetails[i];
          this.activeStations[
            iterator
          ] = this.userInfo.userFacilityData.claimCountDetails[i].stationNumber;
          this.stationsClaimCounts[iterator].activedChecked = true;
          iterator++;
        }
      }
    }

    // tslint:disable-next-line:max-line-length
    (this.checkMarkedStationsShownInAssignStationsTable = this.getActiveCheckedStations().map(
      assignedStationNumber => String(assignedStationNumber)
    )),
      sessionStorage.setItem('activeStations', this.activeStations.join(','));
  }

  // Gets the permission from the session, It is used in the html to show and hide things
  getUserPermissions() {
    this.homePermission = JSON.parse(sessionStorage.getItem('userInfo'))[
      'permissions'
    ]['home'];
    console.log(JSON.stringify(this.homePermission));
  }

  setRoles() {
    for (let i = 0; i < this.userRoles.length; i++) {
      if (i !== this.userRoles.length - 1) {
        this.roles = this.roles + this.userRoles[i] + ', ';
      } else {
        this.roles = this.roles + this.userRoles[i];
      }
    }
  }

  setUserInfo() {
    if (this.userInfo === undefined) {
      this.userInfo = JSON.parse(sessionStorage.getItem('userInfo'));
      // console.log(this.userInfo);
      // if (!!this.userInfo) {
      this.userName = this.userInfo.userName;
      this.lastLogin = this.userInfo.lastLogin;
      this.userRoles = this.userInfo.userRoles;
      // }
    }
  }

  getActiveCheckedStations(): string[] {
    return this.stationsClaimCounts
      .filter(assignedStation => assignedStation.activedChecked)
      .map(assignedStation => assignedStation.stationNumber);
  }

  onSetActiveClicked(): void {
    this.activeStations = this.getActiveCheckedStations();
    sessionStorage.setItem('activeStations', this.activeStations.join(','));
  }

  onRefreshStatsClicked(message: String): void {
    console.log('Refresh stats clicked!!');
  }

  //   onClickHeaderCheckMark(ev): void {
  //     this.stationsClaimCounts.forEach(
  //       assignedStation => (assignedStation.activedChecked = ev.target.checked)
  //     );
  //   }

  isAllChecked(): boolean {
    return this.stationsClaimCounts.every(_ => _.activedChecked);
  }

  onClickSelectAll() {
    const element = <HTMLInputElement>document.getElementById(
      'selectAllCheckBox'
    );
    const isChecked = element.checked;
    for (const assignedStation of this.stationsClaimCounts) {
      assignedStation.activedChecked = isChecked;
    }
  }
}
