import { HomeComponent } from './home.component';

describe('HomeComponent', () => {
  const userInfo = {
    userName: 'VHAISMBAIAHBBB',
    lastLogin: '10/06/2017 11:33:16',
    userRoles: ['ADMIN'],
    permissions: {
      claimDetail: {
        manualReconcilation: 'true',
        reconcile: 'true',
        process: 'true',
        print: 'true',
        reroute: 'true',
        disapprove: 'true'
      },
      searchClaim: {
        search: 'true',
        print: 'true',
        clear: 'true',
        visn: 'true',
        hero: 'true',
        disapprove: 'true',
        reroute: 'true'
      },
      claimsMenu: {
        paymentError: 'true',
        unmatchedPayments: 'true',
        inprocess: 'true',
        aged: 'true',
        searchClaim: 'true',
        rejectClaims: 'true',
        awaitingProcessing: 'true'
      },
      reportsMenu: {
        claimsAwaitingProcessing: 'true',
        reroutedClaims: 'true',
        claimsInprocessSummary: 'true',
        vistAError: 'true',
        claimsCompleted: 'true',
        CPEReport: 'true',
        claimsCompletedSummary: 'true',
        claimsInprocess: 'true',
        outOfSystemPaymentsSummary: 'true',
        BPPR16: 'true',
        outOfSystemPayments: 'true',
        claimsAwaitingProcessingSummary: 'true',
        feeReport: 'true'
      },
      home: {
        refreshStats: 'true',
        setActive: 'true'
      }
    },
    userFacilityData: {
      claimCountDetails: [
        {
          stationNumber: 'VISN',
          numberOfClaimsAwaiting: '0',
          numberOfClaimsInProcess: '0',
          numberOfClaimsRejected: '2'
        },
        {
          stationNumber: '123',
          numberOfClaimsAwaiting: '1',
          numberOfClaimsInProcess: '0',
          numberOfClaimsRejected: '0'
        },
        {
          stationNumber: '402',
          numberOfClaimsAwaiting: '6',
          numberOfClaimsInProcess: '0',
          numberOfClaimsRejected: '0'
        },
        {
          stationNumber: '405',
          numberOfClaimsAwaiting: '0',
          numberOfClaimsInProcess: '0',
          numberOfClaimsRejected: '1'
        },
        {
          stationNumber: '509',
          numberOfClaimsAwaiting: '4',
          numberOfClaimsInProcess: '0',
          numberOfClaimsRejected: '0'
        }
      ],
      totalNumberOfClaimsAwaiting: '11',
      totalNumberOfClaimsInProcess: '0',
      totalNumberOfClaimsRejected: '3',
      visns: '23,8',
      privacyRestrictions: '999444555'
    }
  };

  const activeStations = ['123', '402', '405', '509'];

  const roles = 'ADMIN';
  let component: HomeComponent;

  beforeEach(() => {
    component = new HomeComponent();
    component.userRoles = [];
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('should setDataTable and getUserPermissions', () => {
    spyOn(component, 'setDataTable');
    spyOn(component, 'getUserPermissions');
    component.ngOnInit();
    expect(component.setDataTable).toHaveBeenCalled();
    expect(component.getUserPermissions).toHaveBeenCalled();
  });

  // testing setUserInfo()
  it('setUserInfo', () => {
    console.log('userInfo', userInfo);
    sessionStorage.setItem('userInfo', JSON.stringify(userInfo));
    component.setUserInfo();

    // Franklin Perez (10/27/2017): Was causing Karma Unit Test to not even run when 
    //   I ran Karma Unit Tests for StationMaintenanceAddContactInfoComponent.
    // expect(component.userInfo).toEqual(userInfo);

    expect(component.userName).toBe(userInfo.userName);
    expect(component.lastLogin).toBe(userInfo.lastLogin);
    expect(component.userRoles).toEqual(userInfo.userRoles);
  });

  it('getUserPermissions', () => {
    component.getUserPermissions();
    expect(component.homePermission).toEqual(userInfo.permissions.home);
  });

  it('setRoles', () => {
    component.setUserInfo();
    component.setRoles();
    expect(component.roles).toBe(roles);
  });

  it('getActiveCheckedStations', () => {
    component.setDataTable();
    expect(component.getActiveCheckedStations()).toEqual(activeStations);
  });

  it('onSetActiveClicked', () => {
    component.setDataTable();
    component.onSetActiveClicked();
    expect(sessionStorage.getItem('activeStations')).toEqual(
      activeStations.join(',')
    );
  });

  //   it('onRefreshStatsClicked', () => {});

  it('isAllChecked', () => {
    expect(component.isAllChecked()).toBe(true);
  });
});
