import { RejectClaimComponent } from './reject-claim.component';
import { OkDisapprovalService } from './service/ok-disapproval.sevice';
import { RejectClaimsService } from './service/reject-claim.service';
import { Observable } from 'rxjs/Observable';
import {
  RequestOptions,
  URLSearchParams,
  Headers,
  Response,
  Http
} from '@angular/http';
import { NgForm } from '@angular/forms';

describe('RejectClaimComponent', () => {
  let component: RejectClaimComponent;
  let rejectClaimsService: RejectClaimsService;
  let disapproveService: OkDisapprovalService;
  let http: Http;

  beforeEach(() => {
    rejectClaimsService = new RejectClaimsService(http);
    disapproveService = new OkDisapprovalService(http);
    component = new RejectClaimComponent(
      rejectClaimsService,
      disapproveService
    );
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });

  it('ngOnInit, should get claims from service ', () => {
    const rejectedClaim = [
      {
        claimAmount: 1698.27,
        claimDate: '02/23/2017',
        claimId: 507,
        claimIdLink: '/claimDetail/507',
        claimStatus: 'REJECTED',
        claimType: 'DENT',
        disapprovedBy: 'VHAISMBAIAHBBB',
        disapprovedDate: '02/23/2017',
        explanation: 'Rejected',
        hero: 'N',
        patientId: '606906559',
        providerName: 'ST JOSEPH HOSP',
        reason: '103',
        rejectionHist: [
          {
            claimQueueId: 292402,
            claim: null,
            enqueueDate: '2017-10-18',
            reason: '103',
            outcome: null,
            enqueueComments: 'Reverse it',
            dequeueDate: null,
            dequeueComments: null,
            claimQueueTypeCd: 'REJECTION_APPROVAL',
            createdBy: 'VHAISMBAIAHBBB',
            dateCreated: '2017-10-18',
            modifiedBy: null,
            dateModified: null
          }
        ]
      }
    ];

    spyOn(rejectClaimsService, 'getRejectClaims').and.callFake(() => {
      return new Observable(observer => observer.next(rejectedClaim));
    });

    sessionStorage.setItem(
      'activeStations',
      '123,521,402,524,525,515,526,516,518,509'
    );
    sessionStorage.setItem('privacyRestrictions', '999444555');

    component.ngOnInit();
    console.log(component.claimsData);
    console.log(rejectedClaim);
    // expect(component.claimsData).toBe(rejectedClaim);
    expect(component.btnClicked).toBeFalsy();
    expect(component.reverseDisapprovalBtnClicked).toBeFalsy();
  });

  it('onSubmit', () => {
    const text = 'test';
    component.currentClaimID = 507;
    let f: NgForm = new NgForm(null, null);
    f.value.comment = text;
    component.onSubmit(f);
    expect(component.tempComments[0].reviewersComments).toEqual(text);
    expect(component.tempComments[0].claimId).toEqual(component.currentClaimID);
  });

  it('okDisapprovalClicked', () => {
    const response = [{ claimId: 507, reviewersComments: '' }];
    spyOn(disapproveService, 'okDisapproval').and.callFake(() => {
      return new Observable(observer => observer.next(response));
    });
    spyOn(component, 'displayConfirmation');
    component.okDisapprovalClicked();
    expect(component.btnClicked).toBeTruthy();
    expect(component.displayConfirmation).toHaveBeenCalled();
  });

  it('reverseDisapprovalClicked', () => {
    const response = [{ claimId: 507, reviewersComments: '' }];
    spyOn(component, 'displayReverseDisapprovalConfirmation');

    spyOn(rejectClaimsService, 'reverseDisapprove').and.callFake(() => {
      return new Observable(observer => observer.next(response));
    });

    component.reverseDisapprovalClicked();
    expect(component.reverseDisapprovalBtnClicked).toBeTruthy();
    expect(component.displayReverseDisapprovalConfirmation).toHaveBeenCalled();
  });

  it('isNoneChecked', () => {
    const rejectedClaim = [
      {
        claimAmount: 1698.27,
        claimDate: '02/23/2017',
        claimId: 507,
        claimIdLink: '/claimDetail/507',
        claimStatus: 'REJECTED',
        claimType: 'DENT',
        disapprovedBy: 'VHAISMBAIAHBBB',
        disapprovedDate: '02/23/2017',
        explanation: 'Rejected',
        hero: 'N',
        patientId: '606906559',
        providerName: 'ST JOSEPH HOSP',
        reason: '103',
        rejectionHist: [
          {
            claimQueueId: 292402,
            claim: null,
            enqueueDate: '2017-10-18',
            reason: '103',
            outcome: null,
            enqueueComments: 'Reverse it',
            dequeueDate: null,
            dequeueComments: null,
            claimQueueTypeCd: 'REJECTION_APPROVAL',
            createdBy: 'VHAISMBAIAHBBB',
            dateCreated: '2017-10-18',
            modifiedBy: null,
            dateModified: null
          }
        ]
      }
    ];

    spyOn(rejectClaimsService, 'getRejectClaims').and.callFake(() => {
      return new Observable(observer => observer.next(rejectedClaim));
    });
    component.ngOnInit();
    expect(component.isNoneChecked()).toBeTruthy();
  });

  it('ngOnDestroy', () => {
    component.ngOnDestroy();
    expect(component.tempComments).toEqual([]);
  });
});
