import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';
import { RequestOptions } from '@angular/http';

import { environment } from '../../../environments/environment';
import { ClaimDetail } from '../../claims/claim-detail/model/ClaimDetail';
import { LineItem } from '../../claims/claim-detail/model/lineItem';
import { ScriptService } from '../../shared/scriptLoader/script.service';
import { RestService } from '../../shared/service/rest.service';
import { PaymentInfo } from './out-of-system-payment.model/payment-info.model';
import { UserInfo } from '../../shared/models/UserInfo';

@Component({
  selector: 'app-out-of-system-payment',
  templateUrl: './out-of-system-payment.component.html',
  styleUrls: ['./out-of-system-payment.component.scss'],
  providers: [ScriptService, RestService]
})
export class OutOfSystemPaymentComponent implements OnInit {
  // Prefilled - readonly from UI perspective
  claimDetail = new ClaimDetail();
  lineItem = new LineItem();

  // Stores all form information
  paymentInfo = new PaymentInfo();
  // Group codes are universal across adjustments, and determine available CARCs (which in turn determine RARCs)
  groupCodes = [];
  // these arrays contain the available selections for each of the five adjustments.
  availableCARCs = [[], [], [], [], []];
  availableRARCs = [[], [], [], [], []];
  // Toggles UI element
  showSelectionSummary = false;
  // Error/Success message
  message = '';
  @ViewChild('pdate') dateField: ElementRef;
  constructor(private script: ScriptService, private rest: RestService, private router: Router) {
    this.script.load('datepicker').then(data => {
    }).catch(error => console.log(error));
  }

  // TODO: Remove datepicker
  saveDate() {
    this.paymentInfo.paymentDate = this.dateField.nativeElement.value;
  }

  ngOnInit() {
    if (!!sessionStorage.getItem('claim')) {
      this.claimDetail = JSON.parse(sessionStorage.getItem('claim'));
    }
    if (!!sessionStorage.getItem('lineItem')) {
      this.lineItem = JSON.parse(sessionStorage.getItem('lineItem'));
    }
    // Grab available group codes
    this.rest.getObjectFromUrl<any>(environment.nodeserver + '/reports/outOfSystemPayment/groupCodes').subscribe(
      data => this.groupCodes = data.adjustmentGroups,
      error => this.message = error
    );
  }
  setAvailableCARCs(i) {
    this.rest.getObjectFromUrl<any>(environment.nodeserver + '/reports/outOfSystemPayment/CARCs/' + this.paymentInfo.adjustments[i].groupCode).subscribe(
      data => this.availableCARCs[i] = data.adjustmentReasons
    );
  }
  setAvailableRARCs(i) {
    this.rest.getObjectFromUrl<any>(environment.nodeserver + '/reports/outOfSystemPayment/RARCs/' + this.paymentInfo.adjustments[i].CARC).subscribe(
      data => this.availableRARCs[i] = data.remittanceRemarks
    );
  }
  onSubmit() {
    const options = new RequestOptions({
      body: {
        'claimIndex': this.claimDetail.claimId,
        'claimProcId': this.lineItem.claimProcId,
        'adjustments': this.paymentInfo.adjustments.filter(adj => adj.RARCs.length !== 0),
        'paymentDate': Date.parse(this.paymentInfo.paymentDate),
        'vaAmount': this.paymentInfo.paymentAmount,
        'checkNo': this.paymentInfo.checkNumber,
        'paymentType': this.paymentInfo.paymentType,
        // TODO: fix with something less brittle (user service?)
        'userName': (JSON.parse(sessionStorage.getItem('userInfo')) as UserInfo).userName
      }
    });
    console.log(JSON.stringify(options.body));
    this.rest.postObjectFromUrl<any>(environment.nodeserver + '/reports/outOfSystemPayment/', options).subscribe(
      // TODO: create universal error handling for page components
      data => this.message = !!data.claimId ? 'success' : 'Error:' + data[0].message,
      error => this.message = error
    );
  }
}
